/*
 * $Id: If.java,v 1.5 2008/06/04 17:32:21 akabane Exp $
 * Copyright (c) 2006 LOGICAL-PARADOX.ORG
 */
package org.logical_paradox.petitbasic.builtin.syntax;

import org.logical_paradox.common.util.StringUtils;
import org.logical_paradox.petitbasic.builtin.BuiltinCommand;
import org.logical_paradox.petitbasic.lex.Token;
import org.logical_paradox.petitbasic.operator.OperationUtils;
import org.logical_paradox.petitbasic.runtime.BasicCommandLine;
import org.logical_paradox.petitbasic.runtime.BasicRuntimeContext;
import org.logical_paradox.petitbasic.runtime.BasicRuntimeEnvironment;
import org.logical_paradox.petitbasic.runtime.ErrorCodeConstant;
import org.logical_paradox.petitbasic.runtime.Expression;
import org.logical_paradox.petitbasic.runtime.exception.BasicLanguageException;
import org.logical_paradox.petitbasic.runtime.exception.FlowControlException;

/**
 * IFD
 * <br><pre>
 * @\F܂D
 * ʁFXe[gg<br>
 * FIF <> THEN {<sԍ>|<>} [ELSE {<sԍ>|<>}]
 * @@@IF <> GOTO <sԍ> [ELSE <sԍ>]
 * ᕶFIF A$="TEST" THEN C=C+1 ELSE D=D-1
 * </pre>
 * @author satoshi akabane@logical-paradox.org
 * @version $Revision: 1.5 $
 */
public class If implements BuiltinCommand {
	/**
	 * R}hsD
	 * @param env ^C
	 * @param ctx ^CReLXg
	 * @param line BASICR}hs(runptr̗͂\̎̈ʒu|CgĂ)
	 * @return s(null: Ȃ)
	 * @throws BasicLanguageException BASICŃG[
	 */
	public Token execute(BasicRuntimeEnvironment env, BasicRuntimeContext ctx, BasicCommandLine line) throws BasicLanguageException {
		ctx.config.log.println("IFsJn");

		Expression expression = new Expression(env, ctx, line);
		Token token = expression.eval();
		Token thenOrGoto = null;

		if(token == null || token.getType() != Token.TYPE_LITERAL) {
			throw new BasicLanguageException(ErrorCodeConstant.SYNTAX_ERROR, -1);
		}
		thenOrGoto = line.getNextToken();
		if(thenOrGoto == null || thenOrGoto.getType() != Token.TYPE_RESERVED_WORD ||
			(!"THEN".equals(thenOrGoto.toString()) && !"GOTO".equals(thenOrGoto))
		) {
			throw new BasicLanguageException(ErrorCodeConstant.SYNTAX_ERROR, -1);
		}

		// ]
		if(token.getType() != Token.TYPE_LITERAL) {
			// ]ʁClȊȌꍇ͍\G[
			throw new BasicLanguageException(ErrorCodeConstant.SYNTAX_ERROR, -1);
		}
		boolean evaluation = false;
		if(token.getValueType() == Token.VTYPE_STR) {
			// l̏ꍇ(󕶎ȊO͑SĐ^)
			evaluation = StringUtils.isEmpty(token.toString()) == false;
		} else {
			// ll̏ꍇ(0͑SĐ^)
			evaluation = "0".equals(token.toString()) == false;
		}

		int ifCounter = 0;
		if(evaluation == false) {
			boolean found = false;
			while(line.hasMoreTokens()) {
				Token t = line.getNextToken();
				if("IF".equals(t.toString())) {
					// IF̃lXg𔭌ꍇCIFJE^𑝂₷
					ifCounter++;
					continue;
				}
				if(!"ELSE".equals(t.toString())) {
					// ELSEȊO͖
					continue;
				}

				// ɓ̂ELSȄꍇ̂
				if(ifCounter > 0) {
					ifCounter--;
				} else {
					// ̈ʒuŒ~
					found = true;
					break;
				}
			}
			if(!found) {
				// s
				return null;
			}
		}

		// sԍw肳Ă̂ł΁Cws֑Jڂ
		Token linenoToken = line.getNextValidToken();
		if(linenoToken != null && linenoToken.getType() == Token.TYPE_LITERAL) {
			// ws֑Jڂ
			int lineno = OperationUtils.intValue(linenoToken, ctx);
			throw new FlowControlException(lineno);
		} else {
			// s|C^߂
			line.rewind();
		}

		ctx.config.log.println("IFsI");
		return null;
	}

}
