/*
 * LOGICAL-PARADOX.ORG
 * Copyright (C)2006 satoshi akabane(akabane@logical-paradox.org)
 * $Id: Return.java,v 1.4 2008/10/08 18:23:24 akabane Exp $
 */
package org.logical_paradox.petitbasic.builtin.syntax;

import java.util.Stack;

import org.logical_paradox.petitbasic.builtin.BuiltinCommand;
import org.logical_paradox.petitbasic.lex.Token;
import org.logical_paradox.petitbasic.operator.OperationUtils;
import org.logical_paradox.petitbasic.runtime.BasicCommandLine;
import org.logical_paradox.petitbasic.runtime.BasicRuntimeContext;
import org.logical_paradox.petitbasic.runtime.BasicRuntimeEnvironment;
import org.logical_paradox.petitbasic.runtime.ErrorCodeConstant;
import org.logical_paradox.petitbasic.runtime.Expression;
import org.logical_paradox.petitbasic.runtime.exception.BasicLanguageException;
import org.logical_paradox.petitbasic.runtime.exception.FlowControlException;

/**
 * RETURND
 * <br><pre>
 * @\FTu[`畜A܂D
 * ʁFXe[gg<br>
 * FRETURN [sԍ]
 * ᕶFRETURN 1200
 * </pre>
 * @author satoshi akabane@logical-paradox.org
 * @version $Revision: 1.4 $
 */
public class Return implements BuiltinCommand {
	/**
	 * R}hsD
	 * @param env ^C
	 * @param ctx ^CReLXg
	 * @param line BASICR}hs(runptr̗͂\̎̈ʒu|CgĂ)
	 * @return s(null: Ȃ)
	 * @throws BasicLanguageException BASICŃG[
	 */
	public Token execute(BasicRuntimeEnvironment env, BasicRuntimeContext ctx, BasicCommandLine line) throws BasicLanguageException {
		ctx.config.log.println("RETURNsJn");

		// Ăяo\ReLXg߂ʒu擾
		Stack calling = ctx.getCallingStructureContext(Gosub.CTXKEY_GOSUB_STACK);
		if(calling.size() == 0) {
			throw new BasicLanguageException(ErrorCodeConstant.RETURN_WITHOUT_GOSUB, -1);
		}

		GosubReturnContext gosubContext = (GosubReturnContext)calling.pop();
		int lineno = gosubContext.lineno;
		int runptr = gosubContext.runptr;

		Token returnLineno = line.getNextValidToken();
		if(returnLineno != null) {
			line.rewind();
			if(returnLineno.getType() != Token.TYPE_DELIMITER) {
				Expression expression = new Expression(env, ctx, line);
				returnLineno = expression.eval();

				if(returnLineno != null && returnLineno.getType() == Token.TYPE_LITERAL) {
					// ]čsԍ擾łꍇ
					lineno = OperationUtils.intValue(returnLineno, ctx);
					runptr = BasicCommandLine.RUNPTR_BEGIN;
				}
			}
		}

		ctx.config.log.println("RETURNsI");

		throw new FlowControlException(lineno, runptr);
	}

}
