/*
 * $Id: PetitBasicFileSystem.java,v 1.3 2007/12/12 18:12:39 akabane Exp $
 * Copyright (c) 2006 LOGICAL-PARADOX.ORG
 */
package org.logical_paradox.petitbasic.fs;

import java.io.BufferedOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

/**
 * PetitBASICzt@CVXeD
 * ̓Iȓo͐ɑ΂鑀́CTuNXŎD
 * @author satoshi akabane@logical-paradox.org
 * @version $Revision: 1.3 $
 */
public abstract class PetitBasicFileSystem {
	/**
	 * RXgN^D
	 */
	public PetitBasicFileSystem() {
	}
	/**
	 * wt@C[hD
	 * @param filename t@C
	 * @return BASICvÔ
	 * @throws IOException ̓G[
	 */
	public byte[] load(String filename) throws IOException {
		InputStream in = getInputStream(filename);
		byte[] data = new byte[in.available()];
		// sɂĂ͓͂obt@O邽߁C1oCgǂ񂾂قm
		for(int i = 0; i < data.length; i++) {
			data[i] = (byte)in.read();
		}
		in.close();
		return data;
	}
	/**
	 * wt@CۑD
	 * @param filename t@C
	 * @param data BASICvÔ
	 * @throws IOException o̓G[
	 */
	public void save(String filename, byte[] data) throws IOException {
		OutputStream out = new BufferedOutputStream(getOutputStream(filename));
		out.write(data);
		out.flush();
		
		out.close();
	}
	/**
	 * wp^[ɍvt@C.
	 * @param filespec t@CXybN
	 * @return t@C̃Xg
	 */
	public abstract String[] searchFileEntry(String filespec);
	/**
	 * wp^[ɍvt@C폜.
	 * @param filespec t@CXybN
	 * @return true:폜 / false:폜łȂ
	 * @throws FileNotFoundException 폜Ώۂ̃t@C݂Ȃ
	 */
	public abstract boolean deleteFileEntry(String filespec) throws FileNotFoundException;
	/**
	 * wt@Cɑ΂o̓Xg[ԂD
	 * @param filename t@C
	 * @return o̓Xg[
	 * @throws IOException t@CȂȂ
	 */
	protected abstract OutputStream getOutputStream(String filename) throws IOException;
	/**
	 * wt@Cɑ΂̓Xg[ԂD
	 * @param filename t@C
	 * @return ̓Xg[
	 * @throws IOException t@CȂȂ
	 */
	protected abstract InputStream getInputStream(String filename) throws IOException;
}
