/*
 * LOGICAL-PARADOX.ORG
 * Copyright (C)2006 satoshi akabane(akabane@logical-paradox.org)
 * $Id: Token.java,v 1.6 2008/10/19 16:48:09 akabane Exp $
 */
package org.logical_paradox.petitbasic.lex;

import org.logical_paradox.common.util.NumberUtils;
import org.logical_paradox.petitbasic.runtime.mathpack.Real;

/**
 * D
 * @author satoshi akabane@logical-paradox.org
 * @version $Revision: 1.6 $
 */
public class Token {
	/** ^Cv - e */
	public static final int TYPE_LITERAL = 1;
	/** ^Cv - Rg */
	public static final int TYPE_COMMENT = 2;
	/** ^Cv - ϐ */
	public static final int TYPE_VARIABLE = 10;
	/** ^Cv - Zq */
	public static final int TYPE_OPERATOR = 50;
	/** ^Cv - \ */
	public static final int TYPE_RESERVED_WORD = 100;
	/** ^Cv -  */
	public static final int TYPE_BRACKET = 51;
	/** ^Cv - f~^ */
	public static final int TYPE_DELIMITER = 60;
	/** ^Cv - LN^ */
	public static final int TYPE_CHARACTER = 99;

	/** ^ - s̃ftHg^ */
	public static final int VTYPE_DEF = 0;
	/** ^ -  */
	public static final int VTYPE_INT = 1;
	/** ^ - Px */
	public static final int VTYPE_SGL = 11;
	/** ^ - {x */
	public static final int VTYPE_DBL = 12;
	/** ^ -  */
	public static final int VTYPE_STR = 100;

	/** \^ - wȂ */
	public static final int RTYPE_NON = 0;
	/** \^ - R}h */
	public static final int RTYPE_CMD = 1;
	/** \^ - Xe[gg */
	public static final int RTYPE_STA = 2;
	/** \^ - Zq */
	public static final int RTYPE_OPR = 50;
	/** \^ - ֐ */
	public static final int RTYPE_FNC = 100;
	/** \^ - VXeϐ */
	public static final int RTYPE_VAR = 110;
	/** \^ - f[^ */
	public static final int RTYPE_DAT = 200;
	/** \^ -  */
	public static final int RTYPE_RMK = 201;

	/** ϐ^Cv - ʏ */
	public static final int VARTYPE_NORMAL = 1;
	/** ϐ^Cv - z */
	public static final int VARTYPE_ARRAY = 16;

	/** \L - 2i\L */
	public static final int DF_BIN = 2;
	/** \L - 8i\L */
	public static final int DF_OCT = 8;
	/** \L - 10i\L */
	public static final int DF_INT = 10;
	/** \L - 16i\L */
	public static final int DF_HEX = 16;

	/** ^ */
	private int type;
	/** l^(ftHg͎s^) */
	private int valueType = VTYPE_DEF;
	/** \^ */
	private int funcType = RTYPE_NON;
	/** ϐ^Cv */
	private int varType = VARTYPE_NORMAL;
	/** l */
	private String strvalue;
	/** l */
	private long intvalue;
	/** l */
	private Real realvalue;
	/** l\LtH[}bg */
	private int decimalFormat = DF_INT;

	/**
	 * RXgN^D
	 * @param tt ^
	 */
	public Token(int tt) {
		type = tt;
	}
	/**
	 * Rs[RXgN^D
	 * @param token ɂȂIuWFNg
	 */
	public Token(Token token) {
		type = token.type;
		valueType = token.valueType;
		funcType = token.funcType;
		intvalue = token.intvalue;
		realvalue = token.realvalue;
		strvalue = token.strvalue;
		decimalFormat = token.decimalFormat;
		varType = token.varType;
	}
	/**
	 * lݒ肷D
	 * @param v l
	 */
	public void setIntValue(long v) {
		intvalue = v;
	}
	/**
	 * lԂD
	 * @return l
	 */
	public long getIntValue() {
		return intvalue;
	}
	/**
	 * lݒ肷D
	 * @param v l
	 */
	public void setRealValue(Real v) {
		realvalue = v;
	}
	/**
	 * lԂD
	 * @return l
	 */
	public Real getRealValue() {
		return realvalue;
	}
	/**
	 * lݒ肷D
	 * @param v l
	 */
	public void setStrValue(String v) {
		strvalue = v;
	}
	/**
	 * lԂD
	 * @return l
	 */
	public String getStrValue() {
		return strvalue;
	}
	/**
	 * ^ԂD
	 * @return ^
	 */
	public int getType() {
		return type;
	}
	/**
	 * l^ԂD
	 * @return l^
	 */
	public int getValueType() {
		return valueType;
	}
	/**
	 * l^ݒ肷D
	 * @param vt l^
	 */
	public void setValueType(int vt) {
		valueType = vt;
	}
	/**
	 * \^ݒ肷D
	 * @param ft \^
	 */
	public void setFuncType(int ft) {
		funcType = ft;
	}
	/**
	 * \^ԂD
	 * @return \^
	 */
	public int getFuncType() {
		return funcType;
	}
	/**
	 * ϐ^Cvݒ肷D
	 * @param vtype ϐ^Cv
	 */
	public void setVarType(int vtype) {
		varType = vtype;
	}
	/**
	 * ϐ^CvԂD
	 * @return ϐ^Cv
	 */
	public int getVarType() {
		return varType;
	}
	/**
	 * \Lݒ肷D
	 * @param df \L
	 */
	public void setDecimalFormat(int df) {
		decimalFormat = df;
	}
	/**
	 * \LԂD
	 * @return \L
	 */
	public int getDecimalFormat() {
		return decimalFormat;
	}
	/**
	 * ̎̕\ԂD
	 * @return ̕\
	 */
	public String toString() {
		if(type != TYPE_LITERAL || valueType == VTYPE_STR) {
			// ełȂꍇ܂͕̏ꍇ́C\̂܂܏o
			return strvalue;
		}
		// 萔l̏ꍇ
		// Ƃĉi[ĂꍇClo͂
		if(realvalue != null) {
			return realvalue.toString();
		} else {
			// ̏ꍇ͐ďo͂
			switch(decimalFormat) {
				// 2ȉꍇ
				case DF_BIN:	return "&B" + NumberUtils.intValueToBinaryString(intvalue);
				// 8ȉꍇ
				case DF_OCT:	return "&O" + NumberUtils.intValueToOctalString(intvalue);
				// 16ȉꍇ
				case DF_HEX:	return "&H" + NumberUtils.intValueToHexString(intvalue);
				// 10i܂͂ȊǑ`
				case DF_INT:
				default:		return NumberUtils.intValueToIntString(intvalue);
			}
		}
	}
}
