/*
 * LOGICAL-PARADOX.ORG
 * Copyright (C)2006 satoshi akabane(akabane@logical-paradox.org)
 * $Id: AbstractProcessor.java,v 1.3 2007/12/26 16:40:14 akabane Exp $
 */
package org.logical_paradox.petitbasic.lex.fsm;

import org.logical_paradox.common.fsm.FiniteStateMachine;
import org.logical_paradox.common.fsm.Symbol;
import org.logical_paradox.petitbasic.runtime.exception.BasicLanguageException;

/**
 * ͌n̂߂̏ԑJڋ@BD
 * @author satoshi akabane@logical-paradox.org
 * @version $Revision: 1.3 $
 */
public abstract class AbstractProcessor extends FiniteStateMachine {
	/** XLiωĂȂƂӖ萔 */
	private static final int SCANNER_UNCHANGED = -1;

	/** fCfbNXl */
	private int breakIndex = -1;
	/** ԑJڒɔ\G[ */
	private BasicLanguageException causedException;
	/** XLip^[ */
	private int scannerPattern = SCANNER_UNCHANGED;

	/**
	 * RXgN^D
	 * @param name ʖ
	 * @throws Exception CX^X̐Ɏs
	 */
	public AbstractProcessor(String name) throws Exception {
		super(name);
	}
	/**
	 * IԂɂȂ܂ŌpĎs
	 * @param symbols ͋L
	 * @param startIndex JnCfbNX
	 */
	public void execute(Symbol[] symbols) throws Exception {
		execute(symbols, 0);
	}
	/**
	 * IԂɂȂ܂ŌpĎs
	 * @param symbols ͋L
	 * @param startIndex JnCfbNX
	 */
	public void execute(Symbol[] symbols, int startIndex) throws Exception {
		breakIndex = startIndex;
		while(breakIndex < symbols.length && stepExec(symbols[breakIndex++]) == true);
		finish();
	}
	/**
	 * ͂fʒuԂD
	 * @return
	 */
	public int getBreakIndex() {
		return breakIndex;
	}
	/**
	 * ]ʒuJE^1߂D
	 */
	protected void rollback() {
		breakIndex--;
	}
	/**
	 * XLip^[ݒ肷D
	 * @param sp XLip^[
	 */
	protected void setScannerPattern(int sp) {
		scannerPattern = sp;
	}
	/**
	 * XLip^[ԂD
	 * @return XLip^[
	 */
	public int getScannerPattern() {
		return scannerPattern;
	}
	/**
	 * ƍʁCXLip^[ωǂԂD
	 * @return true:ω / false:ωĂȂ
	 */
	public boolean isScannerChanged() {
		return scannerPattern != SCANNER_UNCHANGED;
	}
	/**
	 * ԑJڒɔ\G[ݒ肷D
	 * @param be ԑJڒɔ\G[
	 */
	protected void setCausedException(BasicLanguageException be) {
		causedException = be;
	}
	/**
	 * ԑJڒɔ\G[ԂD
	 * @return ԑJڒɔ\G[
	 */
	public BasicLanguageException getCausedException() {
		return causedException;
	}
}
