/*
 * LOGICAL-PARADOX.ORG
 * Copyright (C)2006 satoshi akabane(akabane@logical-paradox.org)
 * $Id: IntegerState.java,v 1.1 2006/05/15 11:42:13 akabane Exp $
 */
package org.logical_paradox.petitbasic.lex.fsm.radix;

import org.logical_paradox.common.fsm.State;

/**
 * ǏԁD
 * @author satoshi akabane@logical-paradox.org
 * @version $Revision: 1.1 $
 */
public class IntegerState implements State {
	/** Ԓl */
	private final int state;

	/**  - G[ */
	public static final IntegerState ERROR = new IntegerState(-1);
	/**  -  */
	public static final IntegerState INITIAL = new IntegerState(1);
	/**  - ^CvXL */
	public static final IntegerState RADIX_SCANNING = new IntegerState(2);
	/**  - 2iXL */
	public static final IntegerState BINARY_SCANNING = new IntegerState(12);
	/**  - 8iXL */
	public static final IntegerState OCTAL_SCANNING = new IntegerState(18);
	/**  - 16iXL */
	public static final IntegerState HEX_SCANNING = new IntegerState(26);
	/**  - I */
	public static final IntegerState FINISH = new IntegerState(999);

	/**
	 * RXgN^D
	 * @param st Ԓl
	 */
	private IntegerState(int st) {
		state = st;
	}
	/**
	 * ԒlԂD
	 * @return Ԓl
	 */
	public int getState() {
		return state;
	}
}
