/*
 * LOGICAL-PARADOX.ORG
 * Copyright (C)2006 satoshi akabane(akabane@logical-paradox.org)
 * $Id: StringProcessor.java,v 1.2 2007/12/26 16:40:14 akabane Exp $
 */
package org.logical_paradox.petitbasic.lex.fsm.string;

import org.logical_paradox.common.fsm.State;
import org.logical_paradox.common.fsm.Symbol;
import org.logical_paradox.petitbasic.lex.Token;
import org.logical_paradox.petitbasic.lex.fsm.AbstractProcessor;
import org.logical_paradox.petitbasic.lex.fsm.CharacterSymbol;

/**
 * 萔邽߂̗LԑJڋ@BD
 * @author satoshi akabane@logical-paradox.org
 * @version $Revision: 1.2 $
 */
public class StringProcessor extends AbstractProcessor {
	/** i[obt@ */
	private StringBuffer sb = new StringBuffer();
	/**  */
	private State state = StringState.INITIAL;

	/**
	 * RXgN^D
	 * @param name ʖ
	 * @throws Exception CX^X̐Ɏs
	 */
	public StringProcessor(String name) throws Exception {
		super(name);
	}
	/**
	 * ԑJڋ@Bɑ΂āC͋LǉD
	 * @param symbol ͋L
	 */
	protected void input(Symbol symbol) {
		if(state == StringState.FINISH || state == StringState.ERROR) {
			// ɏIԂȂ̂ŉȂ
			return;
		}
		CharacterSymbol cs = (CharacterSymbol)symbol;
		char c = cs.getCharacter();
		if(c == '"') {
			if(state == StringState.INITIAL) {
				state = StringState.SCANNING;
			} else if(state == StringState.SCANNING) {
				state = StringState.FINISH;
			}
		} else if(state == StringState.INITIAL) {
			// quoteȂ̂ɂȂ葼̋Lꍇ̓G[
			state = StringState.ERROR;
		} else {
			sb.append(c);
		}
	}
	/**
	 * IԂ𔻒肷D
	 * @return true:I / false:p
	 */
	protected boolean isFiniteState() {
		return state == StringState.FINISH;
	}
	/**
	 * ԑJڋ@BXLf[^ԂD
	 * e(valuetype=)̃g[NԂD
	 * @return XLꂽf[^
	 */
	public Object getResult() {
		Token token = new Token(Token.TYPE_LITERAL);
		token.setValueType(Token.VTYPE_STR);
		token.setStrValue(sb.toString());

		return token;
	}
	/**
	 * ݂̏ԂԂD
	 * @return ݂̏
	 */
	public State getState() {
		return state;
	}
}
