/*
 * LOGICAL-PARADOX.ORG
 * Copyright (C)2006 satoshi akabane(akabane@logical-paradox.org)
 * $Id: DivisionOperation.java,v 1.4 2006/10/21 08:55:30 akabane Exp $
 */
package org.logical_paradox.petitbasic.operator;

import org.logical_paradox.petitbasic.lex.Token;
import org.logical_paradox.petitbasic.runtime.BasicRuntimeContext;
import org.logical_paradox.petitbasic.runtime.ErrorCodeConstant;
import org.logical_paradox.petitbasic.runtime.exception.BasicLanguageException;
import org.logical_paradox.petitbasic.runtime.mathpack.Real;

/**
 * ZZqD
 * PƑQZĕԂD
 * @author satoshi akabane@logical-paradox.org
 * @version $Revision: 1.4 $
 */
public class DivisionOperation implements Operation {
	/**
	 * ZsD
	 * @param ctx BASIC^CReLXg
	 * @param v1 P(PZq̏ꍇnull)
	 * @param v2 Q
	 * @return vZ
	 * @throws BasicLanguageException vZɔG[Ȃ
	 */
	public Token doOperation(BasicRuntimeContext context, Token v1, Token v2) throws BasicLanguageException {
		if(OperationUtils.isStringValueType(v1.getValueType(), v2.getValueType(), context.getDefaultVarType())) {
			// ^̂type mismatch
			throw new BasicLanguageException(ErrorCodeConstant.TYPE_MISMATCH);
		}
		Token token = new Token(Token.TYPE_LITERAL);
		token.setDecimalFormat(Token.DF_INT);

		// Z̏ꍇC؂ꂸɏꍇ̂ŏBCDZs
		Real v1r = v1.getRealValue();
		Real v2r = v2.getRealValue();

		// ^͑SĔ{x^ɕϊ
		if(v1.getValueType() == Token.VTYPE_INT) {
			v1r = context.config.mathpack.doubleValue(v1.getIntValue());
		}
		if(v2.getValueType() == Token.VTYPE_INT) {
			v2r = context.config.mathpack.doubleValue(v2.getIntValue());
		}

		Real answer = context.config.mathpack.fp_DIV(v1r, v2r);

		if(answer == null) {
			// 0Z
			throw new BasicLanguageException(ErrorCodeConstant.DIVISION_BY_ZERO);
		}

		token.setRealValue(answer);
		token.setValueType(Token.VTYPE_DBL);

		return token;
	}

}
