/*
 * LOGICAL-PARADOX.ORG
 * Copyright (C)2006 satoshi akabane(akabane@logical-paradox.org)
 * $Id: LogicalXorOperation.java,v 1.3 2008/03/30 16:51:51 akabane Exp $
 */
package org.logical_paradox.petitbasic.operator.lo;

import org.logical_paradox.petitbasic.lex.Token;
import org.logical_paradox.petitbasic.operator.Operation;
import org.logical_paradox.petitbasic.operator.OperationUtils;
import org.logical_paradox.petitbasic.runtime.BasicRuntimeContext;
import org.logical_paradox.petitbasic.runtime.ErrorCodeConstant;
import org.logical_paradox.petitbasic.runtime.exception.BasicLanguageException;

/**
 * rI_a.
 * PƑQ̔rI_aԋpD
 * @author satoshi akabane@logical-paradox.org
 * @version $Revision: 1.3 $
 */
public class LogicalXorOperation implements Operation {
	/**
	 * ZsD
	 * @param ctx BASIC^CReLXg
	 * @param v1 P(PZq̏ꍇnull)
	 * @param v2 Q
	 * @return vZ
	 * @throws BasicLanguageException vZɔG[Ȃ
	 */
	public Token doOperation(BasicRuntimeContext context, Token v1, Token v2) throws BasicLanguageException {
		if(OperationUtils.isStringValueType(v1.getValueType(), v2.getValueType(), context.getDefaultVarType())) {
			// ^̂type mismatch
			throw new BasicLanguageException(ErrorCodeConstant.TYPE_MISMATCH);
		}

		// _Z͐mōsȂ
		int i1 = OperationUtils.intValue(v1, context);
		int i2 = OperationUtils.intValue(v2, context);

		int result = i1 ^ i2;

		// ߂l͐
		Token token = new Token(Token.TYPE_LITERAL);
		token.setValueType(Token.VTYPE_INT);
		token.setDecimalFormat(Token.DF_INT);
		token.setIntValue(result);

		return token;
	}

}
