/*
 * LOGICAL-PARADOX.ORG
 * Copyright (C)2006 satoshi akabane(akabane@logical-paradox.org)
 * $Id: BasicRuntimeEnvironment.java,v 1.20 2008/10/19 16:48:09 akabane Exp $
 */
package org.logical_paradox.petitbasic.runtime;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;

import org.logical_paradox.common.io.ExpandableBuffer;
import org.logical_paradox.petitbasic.fs.GenericFile;
import org.logical_paradox.petitbasic.lex.Token;
import org.logical_paradox.petitbasic.runtime.exception.BasicLanguageException;
import org.logical_paradox.petitbasic.var.VariableTable;

/**
 * BASIC^CD
 * @author satoshi akabane@logical-paradox.org
 * @version $Revision: 1.20 $
 */
public class BasicRuntimeEnvironment {
	/** Ōɒfꂽsԍ/sItZbg\萔 */
	public static final int NONE_BROKEN = -1;
	/** G[ĂȂԂ\萔 */
	public static final int NO_ERROR = -1;

	/** BASIC^CRtBO[V */
	public BasicRuntimeConfig config;
	/** ϐǗe[u */
	public final VariableTable variableTable = new VariableTable(this);

	/** C^[v^[ɓo^ĂvO(L[: sԍ l:ԃR[h) */
	private TreeMap program = new TreeMap();

	/** ݂̃ftHg̐l^ */
	private int defaltValueType;

	/** BASIC^C */
	private final BasicRuntime runtime;
	/** Ōɓo^ꂽsԍ */
	private int lastEntryLine = -1;
	/** ŌɃvOfꂽsԍ */
	private int lastBrokenLine = NONE_BROKEN;
	/** ŌɃvOfꂽsItZbg */
	private int lastBrokenRunPtr = NONE_BROKEN;

	/** ŌɃG[sԍ(-1: _CNg[h) */
	private int lastErrorCausedLine = NO_ERROR;
	/** ŌɔG[R[h(-1: ĂȂ)*/
	private int lastErrorCausedCode = NO_ERROR;
	/** f[^\̐擪ʒuێCfbNX */
	private List dataIndex = new ArrayList();
	/** ݂̃f[^ǂݎʒusԍ */
	private int dataLineptr = 0;
	/** ݂̃f[^ǂݎʒu|C^ */
	private int dataptr = 0;

	/** vOs\ǂ */
	public boolean running = false;

	/** ϐƂ̃ftHg^ */
	private int[] defaultVariableType;

	/** ݎgp\ȃt@C̃CX^X */
	private GenericFile[] genericFiles;

	/**
	 * RXgN^D
	 * @param cfg BASIC^CRtBO[V
	 */
	public BasicRuntimeEnvironment(BasicRuntime rt, BasicRuntimeConfig cfg) {
		runtime = rt;
		config = cfg;
		defaltValueType = cfg.vartype;
		defaultVariableType = new int[26];		// AtoZ

		initDefaultVariableType();
	}
	/**
	 * Ɉt@C̐ύXD
	 * ύX쎞CɃI[vĂt@C΁CIɃN[YD
	 * @param count ANZX\t@C
	 * @throws IOException N[YɎs(ݒ͕ύXȂ)
	 */
	public void setMaxFiles(int count) throws IOException {
		// ŏɑSt@C
		closeAllFiles();

		// SẴt@CN[YꂽꍇCV̈mۂ
		genericFiles = new GenericFile[count];
	}
	/**
	 * ɃANZXłt@C̐ԂD
	 * @return t@C
	 */
	public int getMaxFiles() {
		return genericFiles == null ? 0 : genericFiles.length;
	}
	/**
	 * I[vĂSẴt@C
	 * @throws IOException t@C̃N[YɎs
	 */
	public void closeAllFiles() throws IOException {
		if(genericFiles != null) {
			for(int i = 0; i < genericFiles.length; i++) {
				genericFiles[i].flush();
				genericFiles[i].close();
			}
		}
	}
	/**
	 * BASICvO̐擪sԍԂD
	 * @return sԍ(-1:Ȃ)
	 */
	public int getProgramStartLineno() {
		if(countProgramLines() == 0) {
			return -1;
		} else {
			Integer lineno = (Integer)program.keySet().iterator().next();
			return lineno.intValue();
		}
	}
	/**
	 * wsԍȏ̍ŏ̍sԍԂD
	 * 񕪒Tœ肷
	 * @param lineno Ƃsԍ
	 * @return sԍ(-1:Ȃ)
	 */
	public int getMinimumLineNoOver(int lineno) {
		BasicCommandLine[] allProgramLines = (BasicCommandLine[])program.values().toArray(new BasicCommandLine[0]);
		boolean loop = true;							// 
		int leftEdge = 0;								// ͈͂̍[
		int rightEdge = allProgramLines.length -1;		// ͈͂̉E[
		int fetched = -1;								// 肳ꂽsԍ

		if(allProgramLines.length == 0) {
			return -1;
		}
		if(allProgramLines[countProgramLines() -1].getLineno() < lineno) {
			// TsԍƓ傫̂Co^ĂȂꍇ
			// TĂȂ
			return -1;
		} else if(getCommandLine(lineno) != null) {
			// w肵sԍƊSɈv̂o^ĂꍇCOKƂ
			return lineno;
		}
		while(loop) {
			int index = leftEdge + ((rightEdge - leftEdge) / 2);
			int candidate = allProgramLines[index].getLineno();

			if(rightEdge == leftEdge) {
				// rΏۂȂ(ꂪŌ̔rƂȂ)
				loop = false;
			}
			if(candidate == lineno) {
				// sԍv̂ŏI
				fetched = candidate;
				loop = false;
			} else if(candidate > lineno) {
				// sԍ͒_EɂꍇC݂̍sԍŐV̌Ƃ
				// 菬̂T
				fetched = candidate;
				rightEdge = index -1;
				if(rightEdge < leftEdge) {
					loop = false;
				}
			} else {
				// sԍ͒_荶ɂ
				leftEdge = index +1;
				if(leftEdge > rightEdge) {
					loop = false;
				}
			}
		}

		return fetched;
	}
	/**
	 * wsԍȉ̍ő̍sԍԂD
	 * 񕪒Tœ肷
	 * @param lineno Ƃsԍ
	 * @return sԍ(-1:Ȃ)
	 */
	public int getMaxLineNoUnder(int lineno) {
		BasicCommandLine[] allProgramLines = (BasicCommandLine[])program.values().toArray(new BasicCommandLine[0]);
		boolean loop = true;							// 
		int leftEdge = 0;								// ͈͂̍[
		int rightEdge = allProgramLines.length -1;		// ͈͂̉E[
		int fetched = -1;								// 肳ꂽsԍ


		if(allProgramLines.length == 0) {
			return -1;
		}
		if(allProgramLines[0].getLineno() > lineno) {
			// o^Ăŏ̍sԍCT̂傫ꍇCTĂȂ
			return -1;
		} else if(getCommandLine(lineno) != null) {
			// w肵sԍƊSɈv̂o^ĂꍇCOKƂ
			return lineno;
		}
		while(loop) {
			int index = leftEdge + ((rightEdge - leftEdge) / 2);
			int candidate = allProgramLines[index].getLineno();

			if(rightEdge == leftEdge) {
				// rΏۂȂ(ꂪŌ̔rƂȂ)
				loop = false;
			}
			if(candidate == lineno) {
				// sԍv̂ŏI
				fetched = candidate;
				loop = false;
			} else if(candidate < lineno) {
				// sԍ₪_EɂꍇC݂̍sԍŐV̌Ƃ
				// 傫̂T
				fetched = candidate;
				leftEdge = index +1;
				if(leftEdge > rightEdge) {
					loop = false;
				}
			} else {
				// sԍ͒_荶ɂ
				rightEdge = index -1;
				if(leftEdge > rightEdge) {
					loop = false;
				}
			}
		}

		return fetched;
	}
	/**
	 * BASIC^CԂD
	 * @return BASIC^C
	 */
	public BasicRuntime getRuntime() {
		return runtime;
	}
	/**
	 * wsԍ̃vOԂD
	 * @param lineno sԍ
	 * @return vOs
	 */
	public BasicCommandLine getCommandLine(int lineno) {
		return (BasicCommandLine)program.get(new Integer(lineno));
	}
	/**
	 * wsԍ݂邩ǂԂD
	 * @param lineno sԍ
	 * @return true: / false:Ȃ
	 */
	public boolean isProgramExists(int lineno) {
		return getCommandLine(lineno) != null;
	}
	/**
	 * BASICvOXgԂD
	 * @return vOXg
	 */
	public Collection getProgramList() {
		return program.values();
	}
	/**
	 * BASICvOXgoCgɕϊĕԂD
	 * @return BASICvÕoCg
	 * @throws IOException BASICvOϊɔ͗O
	 */
	public byte[] getProgramData() throws IOException {
		ExpandableBuffer exb = new ExpandableBuffer();
		for(Iterator it = getProgramList().iterator(); it.hasNext();) {
			BasicCommandLine line = (BasicCommandLine)it.next();
			exb.write(line.getBytes());
			exb.write("\r\n".getBytes());
		}

		return exb.byteStream();
	}
	/**
	 * BASICR}hsvOƂēo^D
	 * @param lineno sԍ
	 * @param comline R}hs
	 */
	public void registerProgram(int lineno, BasicCommandLine comline) {
		program.put(new Integer(lineno), comline);
		// vOςꂽꍇCfĂvO͌psƂ
		setLastBrokenLine(BasicRuntimeEnvironment.NONE_BROKEN);
		setLastBrokenRunPtr(BasicRuntimeEnvironment.NONE_BROKEN);

		// f[^̃CfbNXXV
		updateDataIndex();
	}
	/**
	 * wsԍ폜D
	 * @param lineno sԍ
	 */
	public void removeProgram(int lineno) {
		program.remove(new Integer(lineno));
	}
	/**
	 * ݓo^ĂvO̍sԂD
	 * @return o^ĂvO̍s
	 */
	public int countProgramLines() {
		return program.size();
	}
	/**
	 * ϐ̈ȂǂD
	 */
	public void clear() {
		variableTable.clear();
		lastBrokenLine = NONE_BROKEN;
		lastBrokenRunPtr = NONE_BROKEN;
		lastErrorCausedCode = NO_ERROR;
		lastErrorCausedLine = NO_ERROR;
		
		updateDataIndex();
	}
	/**
	 * Ōɓo^ꂽsԍݒ肷D
	 * @param lno sԍ
	 */
	public void setLastEntryLine(int lno) {
		lastEntryLine = lno;
	}
	/**
	 * Ōɓo^ꂽsԍԂD
	 * @return sԍ
	 */
	public int getLastEntryLine() {
		return lastEntryLine;
	}
	/**
	 * ŌɃvOfꂽsԍԂD
	 * @return lastBrokenLine vOfꂽsԍ(-1:fȂ)
	 * @see NONE_BROKEN
	 */
	public int getLastBrokenLine() {
		return lastBrokenLine;
	}
	/**
	 * ŌɃvOfꂽsԍݒ肷D
	 * @param lastBrokenLine vOfꂽsԍ(-1:fȂ)
	 * @see NONE_BROKEN
	 */
	public void setLastBrokenLine(int lastBrokenLine) {
		this.lastBrokenLine = lastBrokenLine;
	}
	/**
	 * ŌɃvOfꂽsʒuԂD
	 * @return lastBrokenRunPtr vOfꂽsʒu
	 * @see NONE_BROKEN
	 */
	public int getLastBrokenRunPtr() {
		return lastBrokenRunPtr;
	}
	/**
	 * ŌɃvOfꂽsʒuݒ肷D
	 * @param lastBrokenRunPtr vOfꂽsʒu
	 * @see NONE_BROKEN
	 */
	public void setLastBrokenRunPtr(int lastBrokenRunPtr) {
		this.lastBrokenRunPtr = lastBrokenRunPtr;
	}
	/**
	 * ftHgϐ^̏.
	 */
	public void initDefaultVariableType() {
		for(int i = 0; i < 26; i++) {
			defaultVariableType[i] = defaltValueType;
		}
	}
	/**
	 * wϐ̃ftHg^ݒ肷D
	 * @param varname ϐ
	 * @param valueType ftHg^
	 */
	public void setDefaultVariableType(String varname, int valueType) {
		char c = varname.toUpperCase().charAt(0);
		int index = c - 'A';
		if(index >= 0 && index < defaultVariableType.length)  {
			defaultVariableType[index] = valueType;
		}
	}
	/**
	 * wϐ̃ftHg^ԂD
	 * @param varname ϐ
	 * @return ftHg^
	 */
	public int getDefaultVariableType(String varname) {
		char c = varname.toUpperCase().charAt(0);
		int index = c - 'A';
		int valueType = getDefaultValueType();		// ftHg̕ϐ^ = ftHg̐l^

		if(index >= 0 && index < defaultVariableType.length)  {
			valueType = defaultVariableType[index];
		}
		
		return valueType;
	}
	/**
	 * ftHg̐l^ݒ肷D
	 * @param type ftHg̕ϐ^
	 */
	public void setDefaultValueType(int type) {
		defaltValueType = type;
	}
	/**
	 * ftHg̐l^ԂD
	 * @return ftHg̕ϐ^
	 */
	public int getDefaultValueType() {
		return defaltValueType;
	}
	/**
	 * ŌɔG[R[hԂD
	 * @return G[R[h(-1:Ȃ)
	 */
	public int getLastErrorCausedCode() {
		return lastErrorCausedCode;
	}
	/**
	 * ŌɔG[R[hݒ肷D
	 * @param lastErrorCausedCode G[R[h
	 */
	public void setLastErrorCausedCode(int lastErrorCausedCode) {
		this.lastErrorCausedCode = lastErrorCausedCode;
	}
	/**
	 * ŌɃG[sԍԂD
	 * @return ŌɃG[sԍ(-1:_CNg[h)
	 */
	public int getLastErrorCausedLine() {
		return lastErrorCausedLine;
	}
	/**
	 * ŌɃG[sԍݒ肷D
	 * @param lastErrorCausedLine ŌɃG[sԍ
	 */
	public void setLastErrorCausedLine(int lastErrorCausedLine) {
		this.lastErrorCausedLine = lastErrorCausedLine;
	}
	/**
	 * f[^\̃CfbNXXV.
	 */
	public void updateDataIndex() {
		// CfbNX̏
		dataIndex.clear();

		for(Iterator it = getProgramList().iterator(); it.hasNext();) {
			BasicCommandLine line = (BasicCommandLine)it.next();
			Token[] tokens = line.getTokens();
			boolean data = false;

			for(int i = 0; i < tokens.length; i++) {
				if(
					tokens[i].getType() == Token.TYPE_RESERVED_WORD &&
					tokens[i].getFuncType() == Token.RTYPE_DAT
				) {
					// f[^\ꍇ
					data = true;
				} else if(
						data &&
						tokens[i].getType() == Token.TYPE_LITERAL &&
						tokens[i].getValueType() == Token.VTYPE_STR
				) {
					// Ƀf[^\oĂāCȍ~̍ŏ̕oꍇ
					dataIndex.add(new DataLocation(line.getLineno(), i));
					data = false;
				}
			}
		}
		
		dataLineptr = 0;
		dataptr = 0;
	}
	/**
	 * f[^ǂݎ|C^̈ʒu擪ɖ߂.
	 */
	public void restoreDataPtr() {
		dataLineptr = 0;
		dataptr = 0;
	}
	/**
	 * f[^ǂݎ|C^̈ʒuCw肳ꂽsԍȍ~̍ł߂ʒuֈړ.
	 * @param lineno sԍ
	 */
	public void restoreDataPtr(int lineno) {
		dataLineptr = 0;
		dataptr = 0;
		for(; dataLineptr < dataIndex.size(); dataLineptr++) {
			DataLocation location = (DataLocation)dataIndex.get(dataLineptr);
			if(location.lineno >= lineno) {
				return;
			}
		}
	}
	/**
	 * ̃f[^Ԃ.
	 * @return f[^
	 * @throws BasicLanguageException ǂݎf[^Ȃ
	 */
	public Token getNextData() throws BasicLanguageException {
		Token token = null;

		while(token == null && dataLineptr < dataIndex.size()) {
			DataLocation location = (DataLocation)dataIndex.get(dataLineptr);
			BasicCommandLine line = getCommandLine(location.lineno);
			Token[] tokens = line.getTokens();
	
			while(dataptr < tokens.length) {
				token = tokens[dataptr++];
				if(
					token.getType() == Token.TYPE_LITERAL &&
					token.getValueType() == Token.VTYPE_STR
				) {
					// ǂݎΏۂ̃f[^𔭌
					break;
				}
			}
			
			if(token == null) {
				dataLineptr++;
				dataptr = 0;
			}
		}
		
		if(token == null) {
			// ǂݎ\ȃf[^Ȃ
			throw new BasicLanguageException(ErrorCodeConstant.OUT_OF_DATA, -1);
		}

		return token;
	}
}
