/*
 * $Id: VariableControlBlock.java,v 1.3 2007/12/01 08:57:08 akabane Exp $
 * Copyright (c) 2006 LOGICAL-PARADOX.ORG
 */
package org.logical_paradox.petitbasic.var;

import org.logical_paradox.petitbasic.runtime.ErrorCodeConstant;
import org.logical_paradox.petitbasic.runtime.exception.BasicLanguageException;

/**
 * ϐǗubND
 * ^COClCȂǂǗĂe[uD
 * @author satoshi akabane@logical-paradox.org
 * @version $Revision: 1.3 $
 */
public class VariableControlBlock {
	private int dimensions = 0;
	/** zϐ̒l */
	private Variable[] values;
	/** ϐ̒l(0p) */
	private Variable value;

	/** Y̏l */
	private int[] subscripts;

	/**
	 * RXgN^D
	 * ̃RXgN^́C̃pbP[W炵ĂяoȂD
	 * ʏϐubN̊蓖ẮCVariableTableōsȂD
	 * @param ss Y̏l(null: 0)
	 * @throws BasicLanguageException Y͈̔̓G[
	 */
	VariableControlBlock(int[] ss) throws BasicLanguageException {
		subscripts = ss;
		dimensions = ss == null ? 0 : ss.length;

		// ϐi[̈쐬
		if(ss != null && ss.length > 0) {
			int[] maxSubscripts = new int[ss.length];
			for(int i = 0; i < ss.length; i++) {
				int n = ss[i] -1;
				if(n < 0) {
					throw new BasicLanguageException(ErrorCodeConstant.SUBSCRIPT_OUT_OF_RANGE, -1);
				}
				maxSubscripts[i] = n;
			}
			
			int need = getIndex(maxSubscripts);
			values = new Variable[need +1];
		}
	}
	/**
	 * ϐ̒lԂD
	 * @return ϐ̒l
	 */
	Variable getValue() {
		return value;
	}
	/**
	 * ϐǗubN̎ԂD
	 * @return 
	 */
	int getDimensions() {
		return dimensions;
	}
	/**
	 * zϐ̒lԂD
	 * @param index Y(null܂0̏ꍇ͒ʏϐƂ)
	 * @return ϐ̒l
	 * @throws BasicLanguageException z̓YG[
	 */
	Variable getValue(int[] index) throws BasicLanguageException {
		return index == null || index.length == 0 ? value : values[getIndex(index)];
	}
	/**
	 * zϐli[D
	 * @param index Y
	 * @param value
	 * @throws BasicLanguageException
	 */
	void setValue(int[] index, Variable value) throws BasicLanguageException {
		if(index == null || index.length == 0) {
			// ʏ̕ϐƂĊi[
			this.value = value;
		} else {
			int idx = getIndex(index);
			values[idx] = value;
		}
	}
	/**
	 * z̓Y1ɕϊD
	 * @param index Y
	 * @return 1\̓Y
	 * @throws BasicLanguageException z̓YG[
	 */
	int getIndex(int[] index) throws BasicLanguageException {
		int idx = 0;
		for(int i = 0; i < subscripts.length -1; i++) {
			if(index[i] < 0 || index[i] >= subscripts[i]) {
				// Y͈̔̓G[
				throw new BasicLanguageException(ErrorCodeConstant.SUBSCRIPT_OUT_OF_RANGE, -1);
			}
			idx += index[i] * subscripts[i];
		}
		idx += index[subscripts.length -1];

		if(idx < 0) {
			// Y͈̔̓G[(1z̏ꍇ͂Ŕ肷)
			throw new BasicLanguageException(ErrorCodeConstant.SUBSCRIPT_OUT_OF_RANGE, -1);
		}

		return idx;
	}
}
