/*
 * $Id: VariableTable.java,v 1.8 2008/10/19 16:48:09 akabane Exp $
 * Copyright (c) 2006 LOGICAL-PARADOX.ORG
 */
package org.logical_paradox.petitbasic.var;

import java.util.HashMap;

import org.logical_paradox.petitbasic.lex.Token;
import org.logical_paradox.petitbasic.operator.OperationUtils;
import org.logical_paradox.petitbasic.runtime.BasicCommandLine;
import org.logical_paradox.petitbasic.runtime.BasicRuntimeContext;
import org.logical_paradox.petitbasic.runtime.BasicRuntimeEnvironment;
import org.logical_paradox.petitbasic.runtime.ErrorCodeConstant;
import org.logical_paradox.petitbasic.runtime.Expression;
import org.logical_paradox.petitbasic.runtime.exception.BasicLanguageException;

/**
 * ϐǗ̈D
 * @author satoshi akabane@logical-paradox.org
 * @version $Revision: 1.8 $
 */
public class VariableTable {
	/** ϐǗubÑ}bv */
	private HashMap variables = new HashMap();
	/** BASIC^C */
	private final BasicRuntimeEnvironment env;

	/**
	 * RXgN^D
	 */
	public VariableTable(BasicRuntimeEnvironment e) {
		env = e;
	}
	/**
	 * w肳ꂽϐ`Ă邩ǂԂD
	 * @param var ϐь^
	 * @return true:`Ă / false:`
	 */
	public boolean isDefined(Token var) {
		return variables.containsKey(key(var));
	}
	/**
	 * ϐATCD
	 * ɓ^^̕ϐ`Ăꍇ́ClXVD
	 * @param ctx ^CReLXg
	 * @param var ϐь^
	 * @param value l
	 * @throws BasicLanguageException z̐錾Ɏs
	 */
	public void assignVariable(BasicRuntimeContext ctx, Token var, Token value) throws BasicLanguageException {
		assignVariable(ctx, var, null, value);
	}
	/**
	 * zϐATCD
	 * ɓ^^̕ϐ`Ăꍇ́ClXVD
	 * @param ctx ^CReLXg
	 * @param var ϐь^
	 * @param index Y
	 * @param value l
	 * @throws BasicLanguageException z̐錾Ɏs
	 */
	public void assignVariable(BasicRuntimeContext ctx, Token var, int[] index, Token value) throws BasicLanguageException {
		if(var.getValueType() == Token.VTYPE_DEF) {
			throw new IllegalArgumentException("ϐ`OɁCϐ^߂Ă");
		}
		String key = key(var);
		VariableControlBlock vcb = (VariableControlBlock)variables.get(key);
		if(vcb == null) {
			// ܂ϐ`ĂȂ̂ŁCVϐǗubN쐬
			int[] dimensions = index == null || index.length == 0 ? null : new int[index.length];
			for(int i = 0; index != null && i < index.length; i++) {
				if(index[i] >= env.config.arrayAutoAllocationCapacity) {
					throw new BasicLanguageException(ErrorCodeConstant.SUBSCRIPT_OUT_OF_RANGE, -1);
				}
				// IɊmۂz̓YTCY10
				dimensions[i] = env.config.arrayAutoAllocationCapacity;
			}
			vcb = new VariableControlBlock(dimensions);
		}

		Variable variable = vcb.getValue(index);
		if(variable == null) {
			// ϐȂꍇ͐Vϐ`
			variable = defineDefaultVariable(var);
		}
		Token castValue = OperationUtils.castValueType(value, variable.valuetype, ctx);
		variable.setValue(castValue);

		// ϐ̍Ċi[
		vcb.setValue(index, variable);
		variables.put(key, vcb);
	}
	/**
	 * ϐԂD
	 * @param ctx ^CReLXg
	 * @param var ϐь^
	 * @param index Y
	 * @return l
	 * @throws BasicLanguageException z̐錾Ɏs
	 */
	public Variable getVariable(BasicRuntimeContext ctx, Token var, int[] index) throws BasicLanguageException {
		if(var.getValueType() == Token.VTYPE_DEF) {
			// ϐ̌^ftHg^̏ꍇC^ɓ肷
			var = new Token(var);
			var.setValueType(getStrictVariableType(var));
		}
		VariableControlBlock vcb = (VariableControlBlock)variables.get(key(var));
		if(vcb == null) {
			// w肳ꂽϐ`̏ꍇCVǗ̈쐬
			Variable variable = defineDefaultVariable(var);
			assignVariable(ctx, var, index, variable.toToken());

			// ēǂݍ
			vcb = (VariableControlBlock)variables.get(key(var));
			if(vcb == null) {
				// łATCȂꍇ͓G[
				throw new BasicLanguageException(ErrorCodeConstant.INTERNAL_ERROR, -1);
			}
		}

		// ϐ擾
		Variable variable = vcb.getValue(index);
		if(variable == null) {
			// 擾ϐ`̏ꍇCV`čĎ擾
			assignVariable(ctx, var, index, defineDefaultVariable(var).toToken());
			variable = vcb.getValue(index);
		}
		return variable;
	}
	/**
	 * ϐԂD
	 * zϐ̏ꍇ͕KvɉBASICR}hsK؂ȓY擾āCzϐԂD
	 * @param ctx BASIC^CReLXg
	 * @param line BASICR}hs
	 * @param var ϐ
	 * @return ϐ
	 * @throws BasicLanguageException z̐錾Ɏs
	 */
	public Variable getVariable(BasicRuntimeContext ctx, BasicCommandLine line, Token var) throws BasicLanguageException {
// TODO veXg
		int[] index = null;
		Token token = line.getNextValidToken();

		if(token != null && "(".equals(token.toString())) {
			// JbȐꍇ͔zȂ̂ŁCs|C^1߂C֐[hŉ͂
			line.rewind();
			index = Expression.getSubscripts(env, ctx, line);
		} else if(token != null){
			line.rewind();
		}
		return getVariable(ctx, var, index);
	}
	/**
	 * VϐǗubN蓖ĂD
	 * @param var ϐь^
	 * @param dimensions Y
	 * @throws BasicLanguageException z2d`G[
	 */
	public void allocate(Token var, int[] dimensions) throws BasicLanguageException {
		// ϐ̌^͂肳
		int valueType = getStrictVariableType(var);
		var.setValueType(valueType);

		String key = key(var);
		VariableControlBlock vcb = (VariableControlBlock)variables.get(key);
		if(vcb != null && dimensions != null && dimensions.length > 0) {
			// z2dɐ錾悤Ƃ
			throw new BasicLanguageException(ErrorCodeConstant.REDIMENSIONED_ARRAY, -1);
		}

		vcb = new VariableControlBlock(dimensions);
		variables.put(key, vcb);
	}
	/**
	 * w̌^ŕϐ`D
	 * @param token g[N
	 * @return `ꂽϐ
	 * @throws BasicLanguageException G[
	 */
	protected Variable defineDefaultVariable(Token token) throws BasicLanguageException {
		int valueType = getStrictVariableType(token);
		String varname = token.getStrValue();
		Variable var = null;

		switch(valueType) {
			case Variable.VTYPE_INT:
				var = env.config.mathpack.intVariable(varname, "0");
				break;
			case Variable.VTYPE_SGL:
				var = env.config.mathpack.floatVariable(varname, "0");
				break;
			case Variable.VTYPE_DBL:
				var = env.config.mathpack.doubleVariable(varname, "0");
				break;
			case Variable.VTYPE_STR:
				var = env.config.mathpack.stringVariable(varname, "");
				break;
			default:
				// (G[)
				throw new BasicLanguageException(ErrorCodeConstant.INTERNAL_ERROR, -1);
		}
		return var;
	}
	/**
	 * ϐ^ԂD
	 * s^̏ꍇC݂̃^CReLXg̏Ԃɉ^ԂD
	 * @param token g[N
	 * @return ϐ^
	 */
	public int getStrictVariableType(Token token) {
		int vtype = token.getValueType();
		if(vtype == Token.VTYPE_DEF) {
			// ̕ϐɑΉftHg^擾
			vtype = env.getDefaultVariableType(token.toString());
		}
		switch(vtype) {
			case Token.VTYPE_SGL:	vtype = Variable.VTYPE_SGL; break;
			case Token.VTYPE_DBL:	vtype = Variable.VTYPE_DBL; break;
			case Token.VTYPE_INT:	vtype = Variable.VTYPE_INT; break;
			case Token.VTYPE_STR:	vtype = Variable.VTYPE_STR; break;
			default:
				// Ȃ-1łԂ
				return -1;
		}

		return vtype;
	}
	/**
	 * ϐǗubÑL[𐶐D
	 * @param var ϐь^
	 * @return L[
	 */
	protected String key(Token var) {
		return (var.getVarType() == Token.VARTYPE_ARRAY ? "A" : "V") +
				"[" + var.getValueType() + "]" + var.toString();
	}
	/**
	 * ϐǗe[uD
	 * SĂ̕ϐjD
	 */
	public void clear() {
		variables.clear();
	}
}
