/**
 * LOGICAL-PARADOX.ORG
 * Copyright (C)2004 satoshi akabane(akabane@logical-paradox.org)
 *
 */
package org.logical_paradox.common.message;

import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;

import org.logical_paradox.common.util.StringUtils;

/**
 * bZ[Wr_[
 * ^ꂽbZ[W\[XCۂ̕gݗĂ܂
 * @author satoshi akabane@logical-paradox.org
 * @version $Revision: 1.1 $
 */
public class MessageBuilder {
	public static final String DEFAULT_MESSAGE_RESOURCE = "message";

	/** bZ[W\[X */
	private ResourceBundle rb = null;

	/**
	 * RXgN^
	 */
	public MessageBuilder() {
		this(DEFAULT_MESSAGE_RESOURCE);
	}
	/**
	 * RXgN^
	 * @param basename bZ[W\[X̃x[X
	 */
	public MessageBuilder(String basename) {
		rb = ResourceBundle.getBundle(basename);
	}
	/**
	 * RXgN^D
	 * @param in ̓Xg[
	 */
	public MessageBuilder(InputStream in) {
		try {
			rb = new PropertyResourceBundle(in);
		} catch (IOException e) {
			throw new RuntimeException();
		}
	}
	/**
	 * bZ[W\[X𕶎ɕϊ
	 * @param resource bZ[W\[X
	 * @return tH[}bgꂽ
	 */
	public String getMessage(MessageResource resource) {
		String mf = "";
		try {
			mf = rb.getString(resource.getMsgCode());
		} catch(MissingResourceException e) {
			// w肳ꂽL[ɑΉ郁bZ[WȂ
			mf = "";
		}
		if(StringUtils.isEmpty(mf)) {
			return "";
		}

		// ݒ肷
		return MessageFormat.format(mf, resource.getParameters());
	}
	/**
	 * bZ[W𕶎ɕϊ
	 * @param code bZ[WID
	 * @return tH[}bgꂽ
	 */
	public String getMessage(String code) {
		return getMessage(new MessageResource(code));
	}
	/**
	 * bZ[W𕶎ɕϊ
	 * @param code bZ[WID
	 * @param o1 1
	 * @return tH[}bgꂽ
	 */
	public String getMessage(String code, Object o1) {
		return getMessage(new MessageResource(code, o1));
	}
	/**
	 * bZ[W𕶎ɕϊ
	 * @param code bZ[WID
	 * @param o1 1
	 * @param o2 2
	 * @return tH[}bgꂽ
	 */
	public String getMessage(String code, Object o1, Object o2) {
		return getMessage(new MessageResource(code, o1, o2));
	}
	/**
	 * bZ[W𕶎ɕϊ
	 * @param code bZ[WID
	 * @param o1 1
	 * @param o2 2
	 * @param o3 3
	 * @return tH[}bgꂽ
	 */
	public String getMessage(String code, Object o1, Object o2, Object o3) {
		return getMessage(new MessageResource(code, o1, o2, o3));
	}
	/**
	 * bZ[W𕶎ɕϊ
	 * @param code bZ[WID
	 * @param objects 
	 * @return tH[}bgꂽ
	 */
	public String getMessage(String code, Object[] objects) {
		return getMessage(new MessageResource(code, objects));
	}
}
