/*
 * $Id: Cint.java,v 1.1 2008/10/26 15:20:19 akabane Exp $
 */
package org.logical_paradox.petitbasic.builtin;

import org.logical_paradox.petitbasic.lex.Token;
import org.logical_paradox.petitbasic.operator.OperationUtils;
import org.logical_paradox.petitbasic.runtime.BasicCommandLine;
import org.logical_paradox.petitbasic.runtime.BasicRuntimeContext;
import org.logical_paradox.petitbasic.runtime.BasicRuntimeEnvironment;
import org.logical_paradox.petitbasic.runtime.ErrorCodeConstant;
import org.logical_paradox.petitbasic.runtime.Expression;
import org.logical_paradox.petitbasic.runtime.exception.BasicLanguageException;

/**
 * CINT֐D
 * <br><pre>
 * @\F̒l𐮐ɕϊD
 * ʁF֐<br>
 * FCINT(<>)
 * ᕶFI=CINT(10.22)
 * </pre>
 * @author satoshi akabane@logical-paradox.org
 * @version $Revision: 1.1 $
 */
public class Cint implements BuiltinCommand {
	/**
	 * R}hsD
	 * @param env ^C
	 * @param ctx ^CReLXg
	 * @param line BASICR}hs(runptr̗͂\̎̈ʒu|CgĂ)
	 * @return s(null: Ȃ)
	 * @throws BasicLanguageException BASICŃG[
	 */
	public Token execute(BasicRuntimeEnvironment env, BasicRuntimeContext ctx, BasicCommandLine line) throws BasicLanguageException {
		Expression expr = new Expression(env, ctx, line, true);
		Token token = expr.eval();
		
		if(!expr.isTerminated()) {
			// ̐
			throw new BasicLanguageException(ErrorCodeConstant.SYNTAX_ERROR, line.getLineno());
		}
		
		// ^ɕϊ
		int vtype = getValueType();
		Token value = OperationUtils.castValueType(token, vtype, ctx);
		
		return value;
	}
	/**
	 * ϊɎgp^擾D
	 * @return ϊ̌^
	 */
	protected int getValueType() {
		return Token.VTYPE_INT;
	}

}
