/*
 * $Id: Instr.java,v 1.1 2008/10/19 16:48:09 akabane Exp $
 */
package org.logical_paradox.petitbasic.builtin;

import java.util.List;
import java.util.ArrayList;

import org.logical_paradox.petitbasic.lex.Token;
import org.logical_paradox.petitbasic.operator.OperationUtils;
import org.logical_paradox.petitbasic.runtime.BasicCommandLine;
import org.logical_paradox.petitbasic.runtime.BasicRuntimeContext;
import org.logical_paradox.petitbasic.runtime.BasicRuntimeEnvironment;
import org.logical_paradox.petitbasic.runtime.ErrorCodeConstant;
import org.logical_paradox.petitbasic.runtime.Expression;
import org.logical_paradox.petitbasic.runtime.exception.BasicLanguageException;

/**
 * INSTR֐D
 * <br><pre>
 * @\F̒Ɋ܂܂镶̈ʒuԂ.
 * ʁF֐<br>
 * FINSTR([<Jnʒu>,]<>,<p^[>)
 * ᕶFA=INSTR(2,"ABCD","CD")
 * </pre>
 * @author satoshi akabane@logical-paradox.org
 * @version $Revision: 1.1 $
 */
public class Instr implements BuiltinCommand {
	/**
	 * R}hsD
	 * @param env ^C
	 * @param ctx ^CReLXg
	 * @param line BASICR}hs(runptr̗͂\̎̈ʒu|CgĂ)
	 * @return s(null: Ȃ)
	 * @throws BasicLanguageException BASICŃG[
	 */
	public Token execute(BasicRuntimeEnvironment env, BasicRuntimeContext ctx, BasicCommandLine line) throws BasicLanguageException {
		List list = new ArrayList();
		Expression expr = new Expression(env, ctx, line, true);
		
		do {
			Token token = expr.eval();
			if(token != null) {
				list.add(token);
			}
		} while(!expr.isTerminated());
		
		if(list.size() != 2 && list.size() != 3) {
			// ̐s
			throw new BasicLanguageException(ErrorCodeConstant.SYNTAX_ERROR, line.getLineno());
		}
		
		Token pos = null;
		Token str = null;
		Token ptn = null;
		
		if(list.size() == 2) {
			pos = new Token(Token.TYPE_LITERAL);
			pos.setValueType(Token.VTYPE_INT);
			pos.setIntValue(1L);
		} else {
			pos = (Token)list.get(0);
			list.remove(0);
		}
		str = (Token)list.get(0);
		ptn = (Token)list.get(1);
		
		int from = (int)OperationUtils.castValueType(pos, Token.VTYPE_INT, ctx).getIntValue() - 1;
		int loc = str.getStrValue().indexOf(ptn.getStrValue(), from) + 1;
		
		Token token = new Token(Token.TYPE_LITERAL);
		token.setValueType(Token.VTYPE_INT);
		token.setDecimalFormat(Token.DF_INT);
		token.setIntValue(loc);
		
		return token;
	}

}
