/*
 * $Id: Int.java,v 1.4 2006/12/10 15:23:06 akabane Exp $
 * Copyright (c) 2006 LOGICAL-PARADOX.ORG
 */
package org.logical_paradox.petitbasic.builtin;

import org.logical_paradox.petitbasic.lex.Token;
import org.logical_paradox.petitbasic.runtime.BasicCommandLine;
import org.logical_paradox.petitbasic.runtime.BasicRuntimeContext;
import org.logical_paradox.petitbasic.runtime.BasicRuntimeEnvironment;
import org.logical_paradox.petitbasic.runtime.ErrorCodeConstant;
import org.logical_paradox.petitbasic.runtime.Expression;
import org.logical_paradox.petitbasic.runtime.exception.BasicLanguageException;

/**
 * INT֐D
 * <br><pre>
 * @\FɎw肳ꂽl𒴂Ȃő̐ԂD
 * ʁF֐<br>
 * FINT(<>)
 * ᕶFA=INT(-0.009921)
 * </pre>
 * @author satoshi akabane@logical-paradox.org
 * @version $Revision: 1.4 $
 */
public class Int implements BuiltinCommand {
	/**
	 * R}hsD
	 * @param env ^C
	 * @param ctx ^CReLXg
	 * @param line BASICR}hs(runptr̗͂\̎̈ʒu|CgĂ)
	 * @return s(null: Ȃ)
	 * @throws BasicLanguageException BASICŃG[
	 */
	public Token execute(BasicRuntimeEnvironment env, BasicRuntimeContext ctx, BasicCommandLine line) throws BasicLanguageException {
		ctx.config.log.println("INT֐sJn");

		Expression expression = new Expression(env, ctx, line, true);
		Token token = expression.eval();
		if(expression.isTerminated() == false) {
			// ɑ(=ɑ)ꍇ̓G[Ƃ
			throw new BasicLanguageException(ErrorCodeConstant.SYNTAX_ERROR);
		}

		if(
			token.getValueType() == Token.VTYPE_STR ||
			(token.getValueType() == Token.VTYPE_DEF && env.getDefaultValueType() == Token.VTYPE_STR)
		) {
			// ^̂type mismatch
			throw new BasicLanguageException(ErrorCodeConstant.TYPE_MISMATCH);
		}

		// ʂ͕K^ŕԋpD
		Token answer = new Token(token);
		answer.setValueType(Token.VTYPE_INT);
		answer.setDecimalFormat(Token.DF_INT);

		if(token.getValueType() == Token.VTYPE_INT) {
			// ̏ꍇ͉ϊȂł̂܂ܕԂ
			long value = token.getIntValue();
			answer.setIntValue(value);
		} else {
			// ̏ꍇmathpackʂ
			Long lv = ctx.config.mathpack.fp_INT(token.getRealValue());
			if(lv == null) {
				// ĕϊłȂꍇOverflowƂ
				throw new BasicLanguageException(ErrorCodeConstant.OVERFLOW);
			}
			answer.setIntValue(lv.longValue());
		}

		return answer;
	}

}
