/*
 * $Id: Kill.java,v 1.1 2007/12/12 18:12:40 akabane Exp $
 */
package org.logical_paradox.petitbasic.builtin;

import java.io.FileNotFoundException;

import org.logical_paradox.petitbasic.fs.PetitBasicFileSystem;
import org.logical_paradox.petitbasic.lex.Token;
import org.logical_paradox.petitbasic.runtime.BasicCommandLine;
import org.logical_paradox.petitbasic.runtime.BasicRuntimeContext;
import org.logical_paradox.petitbasic.runtime.BasicRuntimeEnvironment;
import org.logical_paradox.petitbasic.runtime.ErrorCodeConstant;
import org.logical_paradox.petitbasic.runtime.Expression;
import org.logical_paradox.petitbasic.runtime.exception.BasicLanguageException;

/**
 * KILL߁D
 * <br><pre>
 * @\Ft@C폜D
 * ʁFR}h<br>
 * FKILL <t@CXybN>
 * ᕶFKILL *.BAS
 * </pre>
 * @author satoshi akabane@logical-paradox.org
 * @version $Revision: 1.1 $
 */
public class Kill implements BuiltinCommand {
	/**
	 * R}hsD
	 * @param env ^C
	 * @param ctx ^CReLXg
	 * @param line BASICR}hs(runptr̗͂\̎̈ʒu|CgĂ)
	 * @return s(null: Ȃ)
	 * @throws BasicLanguageException BASICŃG[
	 */
	public Token execute(BasicRuntimeEnvironment env, BasicRuntimeContext ctx, BasicCommandLine line) throws BasicLanguageException {
		Expression expression = new Expression(env, ctx, line);
		Token token = expression.eval();
		String filespec = "*";
		
		if(token == null || token.getType() != Token.TYPE_LITERAL || token.getValueType() != Token.VTYPE_STR) {
			throw new BasicLanguageException(ErrorCodeConstant.SYNTAX_ERROR, line.getLineno());
		}
			
		filespec = token.getStrValue();
		
		// t@C
		PetitBasicFileSystem fs = env.getRuntime().getRuntimeConfig().fileSystem;
		boolean rc = false;
		try {
			rc = fs.deleteFileEntry(filespec);
		} catch(FileNotFoundException fne) {
			// w肳ꂽp^[ɍvt@CȂ
			throw new BasicLanguageException(ErrorCodeConstant.FILE_NOT_FOUND, line.getLineno());
		}
		
		if(!rc) {
			// ǂݍݐpȂǂŁCt@C̍폜Ɏsꍇ
			throw new BasicLanguageException(ErrorCodeConstant.DISK_WRITE_PROTECTED, line.getLineno());
		}
		return null;
	}

}
