/*
 * $Id: LeftDL.java,v 1.1 2008/10/19 16:48:09 akabane Exp $
 */
package org.logical_paradox.petitbasic.builtin;

import java.util.ArrayList;
import java.util.List;

import org.logical_paradox.petitbasic.lex.Token;
import org.logical_paradox.petitbasic.operator.OperationUtils;
import org.logical_paradox.petitbasic.runtime.BasicCommandLine;
import org.logical_paradox.petitbasic.runtime.BasicRuntimeContext;
import org.logical_paradox.petitbasic.runtime.BasicRuntimeEnvironment;
import org.logical_paradox.petitbasic.runtime.ErrorCodeConstant;
import org.logical_paradox.petitbasic.runtime.Expression;
import org.logical_paradox.petitbasic.runtime.exception.BasicLanguageException;

/**
 * LEFT$֐D
 * <br><pre>
 * @\F[w蕶oD
 * ʁF֐<br>
 * FLEFT$(<>,<>)
 * ᕶFA$=LEFT$("ABCDEFG",2)
 * </pre>
 * @author satoshi akabane@logical-paradox.org
 * @version $Revision: 1.1 $
 */
public class LeftDL implements BuiltinCommand {
	/**
	 * R}hsD
	 * @param env ^C
	 * @param ctx ^CReLXg
	 * @param line BASICR}hs(runptr̗͂\̎̈ʒu|CgĂ)
	 * @return s(null: Ȃ)
	 * @throws BasicLanguageException BASICŃG[
	 */
	public Token execute(BasicRuntimeEnvironment env, BasicRuntimeContext ctx, BasicCommandLine line) throws BasicLanguageException {
		Expression expr = new Expression(env, ctx, line, true);
		List tokens = new ArrayList();
		do {
			Token token = expr.eval();
			if(token != null) {
				tokens.add(token);
			}
		} while(!expr.isTerminated());
		
		if(tokens.size() != 2) {
			// ̐s
			throw new BasicLanguageException(ErrorCodeConstant.SYNTAX_ERROR, line.getLineno());
		}
		
		Token[] params = (Token[])tokens.toArray(new Token[0]);
		String str = params[0].getStrValue();
		int len = (int)OperationUtils.castValueType(params[1], Token.VTYPE_INT, ctx).getIntValue();
		
		if(len < 0) {
			// s
			throw new BasicLanguageException(ErrorCodeConstant.ILLEGAL_FUNCTION_CALL, line.getLineno());
		}
		String value = "";
		if(len > 0) {
			len = str.length() > len ? len : str.length();
			value = str.substring(0, len);
		}
		
		Token token = new Token(Token.TYPE_LITERAL);
		token.setValueType(Token.VTYPE_STR);
		token.setStrValue(value);
		
		return token;
	}

}
