/*
 * LOGICAL-PARADOX.ORG
 * Copyright (C)2005 satoshi akabane(akabane@logical-paradox.org)
 * $Id: Print.java,v 1.5 2008/09/28 15:29:35 akabane Exp $
 */
package org.logical_paradox.petitbasic.builtin;

import java.io.IOException;

import org.logical_paradox.petitbasic.lex.Token;
import org.logical_paradox.petitbasic.runtime.BasicCommandLine;
import org.logical_paradox.petitbasic.runtime.BasicRuntimeContext;
import org.logical_paradox.petitbasic.runtime.BasicRuntimeEnvironment;
import org.logical_paradox.petitbasic.runtime.ErrorCodeConstant;
import org.logical_paradox.petitbasic.runtime.Expression;
import org.logical_paradox.petitbasic.runtime.exception.BasicLanguageException;


/**
 * PRINT
 * @author satoshi akabane@logical-paradox.org
 * @version $Revision: 1.5 $
 */
public class Print implements BuiltinCommand {
	/**
	 * R}hsD
	 * @param env ^C
	 * @param ctx ^CReLXg
	 * @param line BASICR}hs(runptr̗͂\̎̈ʒu|CgĂ)
	 * @return s(null: Ȃ)
	 * @throws BasicLanguageException BASICŃG[
	 */
	public Token execute(BasicRuntimeEnvironment env, BasicRuntimeContext ctx, BasicCommandLine line) throws BasicLanguageException {
		ctx.config.log.println("PRINTsJn");

		StringBuffer sb = new StringBuffer();
		Expression expr = new Expression(env, ctx, line);
		boolean exitf = false;
		boolean crlf = true;
		do {
			Token token = expr.eval();
			if(token != null && Token.TYPE_LITERAL == token.getType()) {
				// ̉͂ɂāC\Ώە񂪎擾ł
				sb.append((sb.length() > 0 && crlf ? "\r\n" : "") + token.toString());
			} else if(!line.hasMoreTokens() || (token = line.getNextValidToken()) == null){
				exitf = true;
				crlf = true;
			} else if(",".equals(token.toString())) {
				sb.append("              ");
				crlf = false;
			} else if(";".equals(token.toString())) {
				crlf = false;
			} else {
				line.rewind();
				exitf = true;
			}
		} while(!exitf);

		// ʂ̏o
		try {
			String str = sb.toString();
			ctx.getOutputStream().write(str.getBytes());
			if(crlf) {
				ctx.getOutputStream().write("\r\n".getBytes());
			}
			ctx.getOutputStream().flush();
		} catch(IOException e) {
			throw new BasicLanguageException(ErrorCodeConstant.DEVICE_IO_ERROR, line.getLineno());
		}

		ctx.config.log.println("PRINTsI");
		return null;
	}
}
