/*
 * $Id: StrDL.java,v 1.1 2008/10/26 15:20:19 akabane Exp $
 */
package org.logical_paradox.petitbasic.builtin;

import org.logical_paradox.petitbasic.lex.Token;
import org.logical_paradox.petitbasic.runtime.BasicCommandLine;
import org.logical_paradox.petitbasic.runtime.BasicRuntimeContext;
import org.logical_paradox.petitbasic.runtime.BasicRuntimeEnvironment;
import org.logical_paradox.petitbasic.runtime.ErrorCodeConstant;
import org.logical_paradox.petitbasic.runtime.Expression;
import org.logical_paradox.petitbasic.runtime.exception.BasicLanguageException;

/**
 * STR$֐D
 * <br><pre>
 * @\FɎw肳ꂽl𕶎ɕϊD
 * ʁF֐<br>
 * FSTR$(<>)
 * ᕶFA$=STR$(0.0012)
 * </pre>
 * @author satoshi akabane@logical-paradox.org
 * @version $Revision: 1.1 $
 */
public class StrDL implements BuiltinCommand {
	/**
	 * R}hsD
	 * @param env ^C
	 * @param ctx ^CReLXg
	 * @param line BASICR}hs(runptr̗͂\̎̈ʒu|CgĂ)
	 * @return s(null: Ȃ)
	 */
	public Token execute(BasicRuntimeEnvironment env, BasicRuntimeContext ctx, BasicCommandLine line) throws BasicLanguageException {
		Expression expr = new Expression(env, ctx, line, true);
		Token token = expr.eval();
		
		if(token == null || token.getType() != Token.TYPE_LITERAL && !expr.isTerminated()) {
			// \G[
			throw new BasicLanguageException(ErrorCodeConstant.SYNTAX_ERROR, line.getLineno());
		}
		
		// ɕϊ
		Token value = new Token(Token.TYPE_LITERAL);
		value.setValueType(Token.VTYPE_STR);
		value.setStrValue(token.toString());
		
		return value;
	}

}
