/*
 * $Id: Next.java,v 1.7 2006/12/24 15:42:43 akabane Exp $
 * Copyright (c) 2006 LOGICAL-PARADOX.ORG
 */
package org.logical_paradox.petitbasic.builtin.syntax;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;

import org.logical_paradox.petitbasic.builtin.BuiltinCommand;
import org.logical_paradox.petitbasic.lex.Token;
import org.logical_paradox.petitbasic.runtime.BasicCommandLine;
import org.logical_paradox.petitbasic.runtime.BasicRuntimeContext;
import org.logical_paradox.petitbasic.runtime.BasicRuntimeEnvironment;
import org.logical_paradox.petitbasic.runtime.ErrorCodeConstant;
import org.logical_paradox.petitbasic.runtime.exception.BasicLanguageException;
import org.logical_paradox.petitbasic.runtime.exception.FlowControlException;
import org.logical_paradox.petitbasic.runtime.mathpack.Mathpack;
import org.logical_paradox.petitbasic.runtime.mathpack.Real;
import org.logical_paradox.petitbasic.var.Variable;

/**
 * NEXTD
 * <br><pre>
 * @\FFORNEXT̊Ԃň͂܂ꂽXe[ggw̉ŌJԂ
 * ʁFXe[gg<br>
 * FNEXT [ϐ[,ϐ[,..]]]
 * ᕶFNEXT J,I
 * </pre>
 * @author satoshi akabane@logical-paradox.org
 * @version $Revision: 1.7 $
 */
public class Next implements BuiltinCommand {
	/**
	 * R}hsD
	 * @param env ^C
	 * @param ctx ^CReLXg
	 * @param line BASICR}hs(runptr̗͂\̎̈ʒu|CgĂ)
	 * @return s(null: Ȃ)
	 * @throws BasicLanguageException BASICŃG[
	 */
	public Token execute(BasicRuntimeEnvironment env, BasicRuntimeContext ctx, BasicCommandLine line) throws BasicLanguageException {
		ctx.config.log.println("NEXTsJn");

		Stack calling = ctx.getCallingStructureContext(For.FOR_NEXT_CTX_NAME);
		boolean loop = true;

		List loopVariables = new ArrayList();
		boolean scanningComma = false;
		while(loop) {
			Token token = line.getNextValidToken();
			if(token == null) {
				// s
				break;
			} else if(token.getType() == Token.TYPE_DELIMITER) {
				// f~^
				line.rewind();
				break;
			} else if(token.getType() == Token.TYPE_VARIABLE && scanningComma == false) {
				// ϐ
				loopVariables.add(token);
				scanningComma = true;
			} else if(",".equals(token.toString()) && scanningComma == true) {
				// J}
				scanningComma = false;
			} else {
				// ȊȌꍇ͍\G[
				throw new BasicLanguageException(ErrorCodeConstant.SYNTAX_ERROR, -1);
			}
		}

		if(calling.size() == 0) {
			throw new BasicLanguageException(ErrorCodeConstant.NEXT_WITHOUT_FOR, -1);
		}

		// [vϐ̏
		ForToStepNextContext forContext = null;
		boolean breakFlag = false;
		if(loopVariables.size() == 0) {
			// ϐƂĎw肳ȂꍇCĂяo\ReLXg̐擪ɂ
			// ReLXg̕ϐo^
			forContext = (ForToStepNextContext)calling.peek();
			loopVariables.add(forContext.loopVariable);
		}

		for(Iterator it = loopVariables.iterator(); breakFlag == false && it.hasNext();) {
			Token token = (Token)it.next();
			forContext = (ForToStepNextContext)calling.pop();

			// [vIĂꍇ͎̃[vϐɂĔ肷
			Token loopVariable = forContext.loopVariable;
			Variable var = env.variableTable.getVariable(ctx, loopVariable, (int[])null);
			if(var == null || loopVariable.getStrValue().equals(token.getStrValue()) == false) {
				// [vϐ݂ȂCϐvȂꍇ̓G[
				throw new BasicLanguageException(ErrorCodeConstant.NEXT_WITHOUT_FOR, -1);
			}
			if(forContext.loopValueType == Token.VTYPE_INT) {
				// ^̏ꍇ
				if(var.intvalue == forContext.loopEnd.getIntValue()) {
					// [vIꍇ
				} else {
					// [vIĂȂꍇC݂̃[vlɑZ
					long step = forContext.loopStep.getIntValue();
					var.intvalue += step;
					// FORReLXgēxςݍ
					calling.push(forContext);
					breakFlag = true;
				}
			} else {
				// ^̏ꍇ
				Mathpack mathpack = ctx.config.mathpack;
				if(mathpack.fp_CMPR(var.realvalue, forContext.loopEnd.getRealValue()) == 0) {
					// [vIꍇ
				} else {
					// [vIĂȂꍇC݂̃[vlɑZ
					Real value = mathpack.fp_ADD(var.realvalue, forContext.loopStep.getRealValue());
					var.realvalue = value;
					// FORReLXgēxςݍ
					calling.push(forContext);
					breakFlag = true;
				}
			}

		}

		if(breakFlag == true && forContext != null) {
			// [vpKvꍇ̓[v
			ctx.config.log.println("* ϐ[" + forContext.loopVariable.getStrValue() + "]Ń[v *");
			throw new FlowControlException(forContext.lineno, forContext.runptr);
		} else {
			ctx.config.log.println("* [vI *");
		}
		ctx.config.log.println("NEXTsI");
		return null;
	}

}
