/*
 * $Id: Read.java,v 1.3 2008/10/09 17:58:45 akabane Exp $
 */
package org.logical_paradox.petitbasic.builtin.syntax;

import org.logical_paradox.petitbasic.builtin.BuiltinCommand;
import org.logical_paradox.petitbasic.lex.Token;
import org.logical_paradox.petitbasic.runtime.BasicCommandLine;
import org.logical_paradox.petitbasic.runtime.BasicRuntimeContext;
import org.logical_paradox.petitbasic.runtime.BasicRuntimeEnvironment;
import org.logical_paradox.petitbasic.runtime.ErrorCodeConstant;
import org.logical_paradox.petitbasic.runtime.Expression;
import org.logical_paradox.petitbasic.runtime.exception.BasicLanguageException;

/**
 * READD
 * <br><pre>
 * @\Ff[^ǂݍށD
 * ʁFXe[gg<br>
 * FREAD <ϐ>[,<ϐ>[,...]]
 * ᕶFREAD A,B$,C!
 * </pre>
 * @author satoshi akabane@logical-paradox.org
 * @version $Revision: 1.3 $
 */
public class Read implements BuiltinCommand {
	/**
	 * R}hsD
	 * @param env ^C
	 * @param ctx ^CReLXg
	 * @param line BASICR}hs(runptr̗͂\̎̈ʒu|CgĂ)
	 * @return s(null: Ȃ)
	 * @throws BasicLanguageException BASICŃG[
	 */
	public Token execute(BasicRuntimeEnvironment env, BasicRuntimeContext ctx, BasicCommandLine line) throws BasicLanguageException {
		Token variable = null;
		Token data = null;
		int[] subscripts = null;
		boolean var = true;

		// ϐ̓ǂݎ
		try {
			while((variable = line.getNextValidToken()) != null) {
				if(var && variable.getType() == Token.TYPE_VARIABLE) {
					Token token = line.peekNextValidToken();
					if(token != null && "(".equals(token.toString())) {
						// JbȐꍇ͔zȂ̂ŁCs|C^1߂C֐[hŉ͂
						subscripts = Expression.getSubscripts(env, ctx, line);
					}
					data = env.getNextData();
					int varValueType = env.variableTable.getStrictVariableType(variable);
					variable.setValueType(varValueType);
	
					if(varValueType != Token.VTYPE_STR) {
						// ϐ̌^^ȊȌꍇCf[^{xɕϊ
						data.setRealValue(env.config.mathpack.doubleValue(data.getStrValue()));
						data.setValueType(Token.VTYPE_DBL);
					}
					
					// ϐl̊蓖
					env.variableTable.assignVariable(ctx, variable, subscripts, data);
					var = false;
				} else if(!var && variable.getType() == Token.TYPE_DELIMITER) {
					// f~^
					line.rewind();
					break;
				} else if(!var && ",".equals(variable.toString())) {
					var = true;
				} else {
					throw new BasicLanguageException(ErrorCodeConstant.SYNTAX_ERROR, line.getLineno());
				}
			}
		} catch(BasicLanguageException be) {
			be.setLineno(line.getLineno());
			throw be;
		}

		return null;
	}

}
