/*
 * $Id: Restore.java,v 1.1 2008/06/04 17:32:21 akabane Exp $
 */
package org.logical_paradox.petitbasic.builtin.syntax;

import org.logical_paradox.petitbasic.builtin.BuiltinCommand;
import org.logical_paradox.petitbasic.lex.Token;
import org.logical_paradox.petitbasic.operator.OperationUtils;
import org.logical_paradox.petitbasic.runtime.BasicCommandLine;
import org.logical_paradox.petitbasic.runtime.BasicRuntimeContext;
import org.logical_paradox.petitbasic.runtime.BasicRuntimeEnvironment;
import org.logical_paradox.petitbasic.runtime.ErrorCodeConstant;
import org.logical_paradox.petitbasic.runtime.Expression;
import org.logical_paradox.petitbasic.runtime.exception.BasicLanguageException;

/**
 * RESTORED
 * <br><pre>
 * @\Ff[^̓ǍJnsZbgD
 * ʁFXe[gg<br>
 * FRESTORE [<sԍ>]
 * ᕶFRESTORE
 * </pre>
 * @author satoshi akabane@logical-paradox.org
 * @version $Revision: 1.1 $
 */
public class Restore implements BuiltinCommand {
	/**
	 * R}hsD
	 * @param env ^C
	 * @param ctx ^CReLXg
	 * @param line BASICR}hs(runptr̗͂\̎̈ʒu|CgĂ)
	 * @return s(null: Ȃ)
	 * @throws BasicLanguageException BASICŃG[
	 */
	public Token execute(BasicRuntimeEnvironment env, BasicRuntimeContext ctx, BasicCommandLine line) throws BasicLanguageException {
		Expression expr = new Expression(env, ctx, line);
		Token token = expr.eval();

		if(token == null) {
			// sԍw肳ĂȂꍇ́Cf[^ǂݎ|C^擪ֈړ
			env.restoreDataPtr();
		} else if(token != null && token.getType() == Token.TYPE_LITERAL) {
			// sԍw肳ĂꍇCwsȍ~̍ł߂sԍփf[^ǂݎ|C^ړ
			Token linenoToken = OperationUtils.castValueType(token, Token.VTYPE_INT, ctx);
			int lineno = (int)linenoToken.getIntValue();
			env.restoreDataPtr(lineno);
		} else {
			// ȊO̓G[
			throw new BasicLanguageException(ErrorCodeConstant.SYNTAX_ERROR, line.getLineno());
		}
		return null;
	}

}
