/*
 * $Id: DataProcessor.java,v 1.1 2007/12/26 16:40:14 akabane Exp $
 */
package org.logical_paradox.petitbasic.lex.fsm.data;

import org.logical_paradox.common.fsm.State;
import org.logical_paradox.common.fsm.Symbol;
import org.logical_paradox.common.util.StringUtils;
import org.logical_paradox.petitbasic.lex.Token;
import org.logical_paradox.petitbasic.lex.fsm.AbstractProcessor;
import org.logical_paradox.petitbasic.lex.fsm.CharacterSymbol;

/**
 * f[^邽߂̗LԑJڋ@B.
 * @author satoshi akabane@logical-paradox.org
 * @version $revision$
 */
public class DataProcessor extends AbstractProcessor {
	/** i[obt@ */
	private StringBuffer sb = new StringBuffer();
	/**  */
	private State state = DataState.INITIAL;

	/**
	 * RXgN^D
	 * @param name ʖ
	 * @throws Exception CX^X̐Ɏs
	 */
	public DataProcessor(String name) throws Exception {
		super(name);
	}
	/**
	 * ԑJڋ@Bɑ΂āC͋LǉD
	 * @param symbol ͋L
	 */
	protected void input(Symbol symbol) {
		if(state == DataState.FINISH || state == DataState.ERROR) {
			// ɏIԂȂ̂ŉȂ
			return;
		}
		CharacterSymbol cs = (CharacterSymbol)symbol;
		char c = cs.getCharacter();

		switch(c) {
			case '"':
				if(state == DataState.INITIAL) {
					state = DataState.QUOTING;
				} else if(state == DataState.QUOTING) {
					state = DataState.FINISH;
				} else {
					// 1ǉ
					sb.append(c);
				}
				break;
			case ',':
			case ':':
				if(state == DataState.QUOTING) {
					sb.append(c);
				} else {
					rollback();
					state = DataState.FINISH;
				}
				break;
			default:
				// 1ǉ
				sb.append(c);
				break;
		}
	}
	/**
	 * IԂ𔻒肷D
	 * @return true:I / false:p
	 */
	protected boolean isFiniteState() {
		return state == DataState.FINISH;
	}
	/**
	 * ԑJڋ@BXLf[^ԂD
	 * e(valuetype=)̃g[NԂD
	 * @return XLꂽf[^
	 */
	public Object getResult() {
		String data = sb.toString();
		if(StringUtils.isEmpty(data)) {
			return null;
		}
		
		// f[^͕K萔ŕԂ
		Token token = new Token(Token.TYPE_LITERAL);
		token.setValueType(Token.VTYPE_STR);
		token.setStrValue(data);
		return token;
	}
}
