/*
 * LOGICAL-PARADOX.ORG
 * Copyright (C)2006 satoshi akabane(akabane@logical-paradox.org)
 * $Id: ReservedWordProcessor.java,v 1.4 2007/12/26 16:40:15 akabane Exp $
 */
package org.logical_paradox.petitbasic.lex.fsm.rw;

import java.util.ArrayList;
import java.util.List;

import org.logical_paradox.common.fsm.Symbol;
import org.logical_paradox.common.util.StringUtils;
import org.logical_paradox.petitbasic.BuiltinCommandLibrary;
import org.logical_paradox.petitbasic.lex.Lex;
import org.logical_paradox.petitbasic.lex.SyntaxConstant;
import org.logical_paradox.petitbasic.lex.Token;
import org.logical_paradox.petitbasic.lex.fsm.AbstractProcessor;
import org.logical_paradox.petitbasic.lex.fsm.CharacterSymbol;
import org.logical_paradox.petitbasic.lex.scanner.Scanner;

/**
 * \邽߂̗LԑJڋ@BD
 * \܂͕ϐ擾D
 * @author satoshi akabane@logical-paradox.org
 * @version $Revision: 1.4 $
 */
public class ReservedWordProcessor extends AbstractProcessor {
	/** ̓obt@ */
	private StringBuffer sb = new StringBuffer();
	/** ϐobt@ */
	private StringBuffer vb = new StringBuffer();
	/** \ꂩǂ̃tO(true:\ / false:ϐ) */
	private boolean reserved = false;
	/** zϐǂ(true:z / false:ʏ) */
	private boolean array = false;
	/** ^ */
	private int valueType = Token.VTYPE_DEF;
	/** ݂̏ */
	private ReservedWordState state = ReservedWordState.INITIAL;

	/**
	 * RXgN^D
	 * @param name ʖ
	 * @throws Exception CX^XɎs
	 */
	public ReservedWordProcessor(String name) throws Exception {
		super(name);
	}
	/**
	 * ͋LԂɑ΂ė^
	 * ͂ꂽLɂāCԂJڂƂ^C~OŃCxg
	 * @param symbol ͋L
	 */
	protected void input(Symbol symbol) {
		if(state == ReservedWordState.FINISH || state == ReservedWordState.ERROR) {
			return;
		}
		CharacterSymbol cs = (CharacterSymbol)symbol;
		char c = Character.toUpperCase(cs.getCharacter());

		// ̗\ꂪ݂邩ǂ𒲂ׂ
		String candidate = sb.toString() + c;
		int rc = BuiltinCommandLibrary.getInstance().contains(candidate);
		// l̏ꍇ
		if(Character.isDigit(c)) {
			if(state == ReservedWordState.INITIAL) {
				// ԂłȂ萔ꍇ̓G[Ƃ
				state = ReservedWordState.ERROR;
			} else if(state == ReservedWordState.SCANNING_WORD && reserved == true) {
				// \荞ݒɐꍇ͂ŏI
				state = ReservedWordState.FINISH;
				// l͍ĕ]̂ŁC|C^߂
				rollback();
			} else {
				// ȊO͒ǉ(ϐƂ)
				sb.append(c);
			}
		// At@xbg܂'$'̏ꍇ
		} else if((state == ReservedWordState.SCANNING_WORD && c == '$') || (c >= 'A' && c <= 'Z')) {
			switch(rc) {
				// \Ȃ
				case BuiltinCommandLibrary.SR_NONE:
					if(state == ReservedWordState.SCANNING_WORD && reserved == true) {
						// ɗ\荞ݒ\ł邱Ƃm肵Ăꍇ͂ŏI
						state = ReservedWordState.FINISH;
						rollback();
					} else {
						if(c == '$') {
							rollback();
						} else {
							// ȊȌꍇC܂ł̓eϐ̈ꕔƂĊm肷
							vb.append(sb.toString());
		
							// XɁC͂ꂽ̂obt@ƂĎ荞
							// ӁF͂ꂽ̂ŗ\̍ĕ]Ȃ߁C1̗\͕KRIɉߕsƂȂ
							sb = new StringBuffer();
							sb.append(c);
						}
						state = ReservedWordState.SCANNING_VAR;
					}
					break;
				// ₠(OvŊY)
				case BuiltinCommandLibrary.SR_CANDIDATE:
					// ܂\̉\̂ŁC\荞ݏԂƂ
					state = ReservedWordState.SCANNING_WORD;
					sb.append(c);
					break;
				// \ꂠ
				case BuiltinCommandLibrary.SR_EXISTS:
					// ȂƂ\ł邱Ƃ킩̂ŁC\荞ݒƂ
					state = ReservedWordState.SCANNING_WORD;
					sb.append(c);
					reserved = true;
					
					int functype = BuiltinCommandLibrary.getInstance().getFunctionTypeOf(candidate);
					int scptn = Lex.SCANNER_STD;
					switch(functype) {
						// f[^\󗝂ꍇCȍ~͑Săf[^\ƂĎ荞
						case Token.RTYPE_DAT:
							scptn = Lex.SCANNER_DATA;
							state = ReservedWordState.FINISH;
							break;
							
						// ߂󗝂ꍇCɎ荞݂𒆎~āCȍ~SăRgĎ荞
						case Token.RTYPE_RMK:
							scptn = Lex.SCANNER_REMARKS;
							state = ReservedWordState.FINISH;
							break;
					}
					// XLip^[̍đI
					setScannerPattern(scptn);
					break;
				// ̑(ʏ킠肦Ȃԋpl)
				default:
					// ̂ŃG[Ƃ
					state = ReservedWordState.ERROR;
			}
		} else {
			// ȊȌꍇ(^CȂ)
			if(state == ReservedWordState.INITIAL) {
				state = ReservedWordState.ERROR;
			} else if(state == ReservedWordState.SCANNING_WORD && reserved == true) {
				rollback();
				state = ReservedWordState.FINISH;
			} else {
				switch(c) {
					case SyntaxConstant.C_VTYPE_SGL: valueType = Token.VTYPE_SGL; break;	// Px
					case SyntaxConstant.C_VTYPE_DBL: valueType = Token.VTYPE_DBL; break;	// {x
					case SyntaxConstant.C_VTYPE_INT: valueType = Token.VTYPE_INT; break;	// 
					case SyntaxConstant.C_VTYPE_STR: valueType = Token.VTYPE_STR; break;	// 
					case SyntaxConstant.C_BRACKET_LEFT: array = true;	// zϐ̓Y break
					default:
						state = ReservedWordState.FINISH;
						rollback();
				}
			}
		}
	}
	/**
	 * ݂̏ԂIԂɂ邩ǂԂ
	 * @return true:I / false:p
	 */
	protected boolean isFiniteState() {
		return state == ReservedWordState.ERROR || state == ReservedWordState.FINISH;
	}
	/**
	 * ԑJڋ@BXLf[^ԂD
	 * \܂͕ϐ̃g[NԂD
	 * @return XLꂽf[^
	 */
	public Object getResult() {
		List results = new ArrayList();

		if(reserved == false) {
			// Ǘ\̎擾Ɏsꍇ́CPȂϐƂĊm肷
			vb.append(sb.toString());
			sb = new StringBuffer();
		}
		// ϐ
		if(StringUtils.isEmpty(vb.toString()) == false) {
			Token token = new Token(Token.TYPE_VARIABLE);
			token.setStrValue(vb.toString());
			token.setValueType(valueType);
			token.setVarType(array ? Token.VARTYPE_ARRAY : Token.VARTYPE_NORMAL);
			results.add(token);
		}

		// ̑
		if(StringUtils.isEmpty(sb.toString()) == false) {
			Token token = new Token(reserved == true ? Token.TYPE_RESERVED_WORD : Token.TYPE_VARIABLE);
			token.setStrValue(sb.toString());
			token.setValueType(valueType);
			token.setVarType(array ? Token.VARTYPE_ARRAY : Token.VARTYPE_NORMAL);
			if(reserved == true) {
				// \̏ꍇC\^ݒ肷
				token.setFuncType(BuiltinCommandLibrary.getInstance().getFunctionTypeOf(token.getStrValue()));
			}
			results.add(token);
		}
		return (Token[])results.toArray(new Token[0]);
	}

}
