/*
 * LOGICAL-PARADOX.ORG
 * Copyright (C)2006 satoshi akabane(akabane@logical-paradox.org)
 * $Id: ModuloOperation.java,v 1.5 2008/09/28 15:29:35 akabane Exp $
 */
package org.logical_paradox.petitbasic.operator;

import org.logical_paradox.petitbasic.lex.Token;
import org.logical_paradox.petitbasic.runtime.BasicRuntimeContext;
import org.logical_paradox.petitbasic.runtime.ErrorCodeConstant;
import org.logical_paradox.petitbasic.runtime.exception.BasicLanguageException;

/**
 * ]ZZqD
 * PƑQ]ZĕԂD
 * @author satoshi akabane@logical-paradox.org
 * @version $Revision: 1.5 $
 */
public class ModuloOperation implements Operation {
	/**
	 * ZsD
	 * @param ctx BASIC^CReLXg
	 * @param v1 P(PZq̏ꍇnull)
	 * @param v2 Q
	 * @return vZ
	 * @throws BasicLanguageException vZɔG[Ȃ
	 */
	public Token doOperation(BasicRuntimeContext ctx, Token v1, Token v2) throws BasicLanguageException {
		long value1 = OperationUtils.intValue(v1, ctx);
		long value2 = OperationUtils.intValue(v2, ctx);
		
		if(value2 == 0) {
			throw new BasicLanguageException(ErrorCodeConstant.DIVISION_BY_ZERO, -1);
		}

		long a = value1 % value2;
		
		Token token = new Token(Token.TYPE_LITERAL);
		token.setValueType(Token.VTYPE_INT);
		token.setDecimalFormat(Token.DF_INT);
		token.setIntValue(a);

		return token;
	}
}
