/*
 * LOGICAL-PARADOX.ORG
 * Copyright (C)2006 satoshi akabane(akabane@logical-paradox.org)
 * $Id: OperationUtils.java,v 1.10 2008/10/26 15:20:19 akabane Exp $
 */
package org.logical_paradox.petitbasic.operator;

import org.logical_paradox.common.util.NumberUtils;
import org.logical_paradox.petitbasic.lex.Token;
import org.logical_paradox.petitbasic.runtime.BasicRuntimeConfig;
import org.logical_paradox.petitbasic.runtime.BasicRuntimeContext;
import org.logical_paradox.petitbasic.runtime.ErrorCodeConstant;
import org.logical_paradox.petitbasic.runtime.exception.BasicLanguageException;
import org.logical_paradox.petitbasic.runtime.mathpack.Real;

/**
 * Zq[eBeBD
 * @author satoshi akabane@logical-paradox.org
 * @version $Revision: 1.10 $
 */
public class OperationUtils {
	/** ^ */
	public static final int VTYPE_STR = 1;
	/** ^ */
	public static final int VTYPE_INT = 2;

	/**
	 * RXgN^D
	 * CX^X֎~
	 */
	private OperationUtils() {
	}
	/**
	 * w肳ꂽCw肳ꂽ^ɕϊD
	 * @param token 
	 * @param valueType l^
	 * @param BASIC^CReLXg
	 * @return ^ϊꂽ
	 * @throws BasicLanguageException ^ϊłȂ
	 * @throws IllegalArgumentException lȊO̎傪^ꂽꍇ
	 */
	public static final Token castValueType(Token token, int valueType, BasicRuntimeContext ctx) throws BasicLanguageException {
		int now = token.getValueType();
		if(token.getType() != Token.TYPE_LITERAL) {
			throw new IllegalArgumentException("萔ȊO̎ɑ΂āC^ϊ悤Ƃ:[" + token.toString() + "]");
		}
		if(now == Token.VTYPE_DEF) {
			// ̌^ftHg^̏ꍇCftHg^Ȃ̂肵Ă
			now = ctx.getDefaultVarType();
		}

		Token result = new Token(token.getType());
		result.setValueType(valueType);

		long intValue = 0;
		Real realValue = null;
		String strValue = null;

		switch(now) {
			// ̌^̏ꍇ
			case Token.VTYPE_INT:
				switch(valueType) {
					case Token.VTYPE_INT:			// 
						intValue = token.getIntValue();
						break;
					case Token.VTYPE_SGL:			// Px
						realValue = ctx.config.mathpack.fp_CSNG(token.getIntValue());
						break;
					case Token.VTYPE_DBL:			// {x
						realValue = ctx.config.mathpack.fp_CDBL(token.getIntValue());
						break;
					case Token.VTYPE_STR:			// 
						throw new BasicLanguageException(ErrorCodeConstant.TYPE_MISMATCH, -1);
					default:
						throw new IllegalArgumentException("ϊ̌^");
				}
				break;
			// ̌^̏ꍇ
			case Token.VTYPE_SGL:
			case Token.VTYPE_DBL:
				switch(valueType) {
					case Token.VTYPE_INT:			// 
						intValue = ctx.config.mathpack.fp_INT(token.getRealValue()).longValue();
						break;
					case Token.VTYPE_SGL:			// Px
						realValue = ctx.config.mathpack.fp_CSNG(token.getRealValue());
						break;
					case Token.VTYPE_DBL:			// {x
						realValue = ctx.config.mathpack.fp_CDBL(token.getRealValue());
						break;
					case Token.VTYPE_STR:			// 
						throw new BasicLanguageException(ErrorCodeConstant.TYPE_MISMATCH, -1);
					default:
						throw new IllegalArgumentException("ϊ̌^");
				}
				break;
			// ̌^^̏ꍇ
			case Token.VTYPE_STR:
				switch(valueType) {
					case Token.VTYPE_STR:
						strValue = token.getStrValue();
						break;
					default:
						throw new BasicLanguageException(ErrorCodeConstant.TYPE_MISMATCH, -1);
				}
				break;
			default:
				throw new IllegalArgumentException("̌^");
		}

		// ϊʂ̊i[
		result.setIntValue(intValue);
		result.setRealValue(realValue);
		result.setStrValue(strValue);

		return result;
	}
	/**
	 * œKȌ^̉񓚃g[N쐬ĕԂD
	 * @param v1 l1
	 * @param v2 l2
	 * @param d3 vZ
	 * @return (null:)
	 */
	public static final Token createAnswerToken(Token v1, Token v2, double d3) {
		// ߂l̃g[N쐬
		Token token = new Token(Token.TYPE_LITERAL);
		int vtype = OperationUtils.getBestValueTypeOf(v1.getValueType(), v2.getValueType());
		token.setValueType(vtype);
		token.setDecimalFormat(Token.DF_INT);

		if(vtype == Token.VTYPE_DEF) {
			// s^̏ꍇ́ClŔ肷
			int i3 = (int)d3;
			double d4 = (double)i3;
			if(d4 == d3) {
				vtype = Token.VTYPE_INT;
			} else {
				vtype = Token.VTYPE_DBL;
			}
		}
		switch(vtype) {
			// 
			case Token.VTYPE_INT:
				token.setStrValue(Integer.toString((int)d3));
				break;
			// Px
			case Token.VTYPE_SGL:
				token.setStrValue(Float.toString((float)d3));
				break;
			// {x
			case Token.VTYPE_DBL:
				token.setStrValue(Double.toString(d3));
				break;
			// 
			case Token.VTYPE_STR:
				return null;
			// ̑(G[)
			default:
				return null;
		}

		return token;
	}
	/**
	 * œKȒl^ԂD
	 * @param vt1 l^1
	 * @param vt2 l^2
	 * @return œK^
	 */
	public static final int getBestValueTypeOf(int vt1, int vt2) {
		// l^̑傫قԂ
		if(vt1 == vt2) {
			return vt1;
		} else {
			return vt1 < vt2 ? vt2 : vt1;
		}
	}
	/**
	 * ^ǂԂD
	 * @param vt l^
	 * @param dt ftHg^
	 * @return
	 */
	public static final boolean isStringValueType(int vt, int dt) {
		return vt == Token.VTYPE_STR || (vt == Token.VTYPE_DEF && dt == Token.VTYPE_STR);
	}
	/**
	 * ^ǂԂD
	 * @param vt1 l^1
	 * @param vt2 l^2
	 * @param dt ftHg^
	 * @return true: / false:l
	 * @throws BasicLanguageException gݍ킹sȏꍇ
	 */
	public static final boolean isStringValueType(int vt1, int vt2, int dt) throws BasicLanguageException {
		vt1 = vt1 == Token.VTYPE_DEF ? dt : vt1;
		vt2 = vt2 == Token.VTYPE_DEF ? dt : vt2;

		// vt1vt2^̏ꍇ́C^
		if(vt1 == vt2 && vt1 == Token.VTYPE_STR) {
			return true;
		}
		// vt1܂vt2^̏ꍇCtype mismatchƂ
		if(vt1 == Token.VTYPE_STR || vt2 == Token.VTYPE_STR) {
			throw new BasicLanguageException(ErrorCodeConstant.TYPE_MISMATCH);
		}
		return false;
	}
	/**
	 * ԂD
	 * @param token f[^\[X
	 * @param ctx ReLXg
	 * @return 
	 * @throws BasicLanguageException ^ϊG[Ȃ
	 */
	public static final int intValue(Token token, BasicRuntimeContext ctx) throws BasicLanguageException {
		int vtype = token.getValueType();
		if(vtype == Token.VTYPE_DEF) {
			vtype = ctx.getDefaultVarType();
		}
		int value = -1;
		switch(vtype) {
			case Token.VTYPE_INT:
				value = (int)token.getIntValue();
				break;
			case Token.VTYPE_SGL:
			case Token.VTYPE_DBL:
				value = ctx.config.mathpack.fp_INT(token.getRealValue()).intValue();
				break;
			default:
				throw new BasicLanguageException(ErrorCodeConstant.TYPE_MISMATCH, -1);
		}
		
		return value;
	}
	/**
	 * ԂD
	 * @param token f[^\[X
	 * @param ctx ReLXg
	 * @return 
	 * @throws BasicLanguageException ^ϊG[Ȃ
	 */
	public static final Real realValue(Token token, BasicRuntimeContext ctx) throws BasicLanguageException {
		int vtype = token.getValueType();
		if(vtype == Token.VTYPE_DEF) {
			vtype = ctx.getDefaultVarType();
		}
		Real value = null;
		switch(vtype) {
			case Token.VTYPE_INT:
				value = ctx.config.mathpack.fp_CDBL(token.getIntValue());
				break;
			case Token.VTYPE_SGL:
			case Token.VTYPE_DBL:
				value = token.getRealValue();
				break;
			default:
				throw new BasicLanguageException(ErrorCodeConstant.TYPE_MISMATCH, -1);
		}
		
		return value;
	}
	/**
	 * lmrC^肷D
	 * @param v1 l1
	 * @param v2 l2
	 * @param ctx ReLXg
	 * @return VTYPE_STR:^ / VTYPE_INT:^
	 * @throws BasicLanguageException ^
	 * @see VTYPE_STR
	 * @see VTYPE_INT
	 */
	public static int compareValueType(Token v1, Token v2, BasicRuntimeContext ctx) throws BasicLanguageException {
		boolean firstIsString = isStringValueType(v1.getValueType(), ctx.getDefaultVarType());
		boolean secondIsString = isStringValueType(v2.getValueType(), ctx.getDefaultVarType());
		
		if(firstIsString != secondIsString) {
			// 1Ƒ2̂ǂ炩Е^ŁCl^ł΃G[
			throw new BasicLanguageException(ErrorCodeConstant.TYPE_MISMATCH, -1);
		}
		
		if(firstIsString == true) {
			return VTYPE_STR;
		} else {
			return VTYPE_INT;
		}
	}
	/**
	 * w肳ꂽɑ΂āClD
	 * 񂩂玚̒l^ւ̃LXg͎IɍsD
	 * @param config BASIC^CRtBO
	 * @param token 
	 * @param value l
	 * @return (tokenƓQ)
	 */
	public static final Token setValue(BasicRuntimeConfig config, Token token, String value) {
		int valueType = token.getValueType();
		if(valueType == Token.VTYPE_DEF) {
			// ftHg^̏ꍇC{xŊm肷(=萔ɊւẮC^mƂƂ͂Ȃ)
			valueType = Token.VTYPE_DBL;
			token.setValueType(valueType);
		}
		switch(valueType) {
			// ^w肳Ăꍇ
			case Token.VTYPE_INT:	token.setIntValue(NumberUtils.intStringToIntValue(value)); break;
			// Px^w肳Ăꍇ
			case Token.VTYPE_SGL:	token.setRealValue(config.mathpack.floatValue(value)); break;
			// {x^܂͎s^̏ꍇ
			case Token.VTYPE_DBL:	token.setRealValue(config.mathpack.doubleValue(value)); break;
			// ^̏ꍇ
			case Token.VTYPE_STR:	token.setStrValue(value); break;
			// ȊO
			default:
		}
		return token;
	}
}
