/*
 * LOGICAL-PARADOX.ORG
 * Copyright (C)2006 satoshi akabane(akabane@logical-paradox.org)
 * $Id: OperatorLibrary.java,v 1.2 2007/04/19 13:08:38 akabane Exp $
 */
package org.logical_paradox.petitbasic.runtime;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Properties;

import org.logical_paradox.common.util.PropertyUtils;
import org.logical_paradox.petitbasic.operator.Operation;

/**
 * ZqnhCuD
 * @author satoshi akabane@logical-paradox.org
 * @version $Revision: 1.2 $
 */
public class OperatorLibrary {
	/** ZqIy[^CũftHg\[Xt@C */
	public static final String DEFAULT_OPERATOR_LIBRARY_FILENAME = "operator.properties";

	/** ZqnhCũ}bv */
	private static final HashMap instances = new HashMap();
	/** Zq̃}bv(L[:Zq / l:nhNX */
	private HashMap opedic = new HashMap();

	/**
	 * RXgN^D
	 * @param prefix ړ
	 */
	protected OperatorLibrary(String prefix) {
		init(prefix);
	}
	/**
	 * Zq̒`[hD
	 * @param filename \[Xt@C
	 */
	protected void init(String filename) {
		Properties pp = PropertyUtils.getProperties(filename);
		Enumeration e = pp.keys();
		while(e.hasMoreElements()) {
			String key = e.nextElement().toString();
			String classname = pp.getProperty(key);
			try {
				Class clazz = Class.forName(classname);
				opedic.put(key.replaceAll("eq", "="), clazz);		// vpeBt@Cł'='̂'eq'ƂĂ
			} catch(Exception ex) {
				// NXt@C̃[hɎs
				// Ƃ肠
			}
		}
	}
	/**
	 * ZqnhCũCX^XԂD
	 * @return ZqnhCũCX^X
	 */
	public static final OperatorLibrary getInstance() {
		return getInstance(DEFAULT_OPERATOR_LIBRARY_FILENAME);
	}
	/**
	 * ZqnhCũCX^XԂD
	 * @param pfx \[Xt@C̐ړ
	 * @return ZqnhCũCX^X
	 */
	public static final OperatorLibrary getInstance(String pfx) {
		OperatorLibrary library = (OperatorLibrary)instances.get(pfx);
		if(library == null) {
			// w肳ꂽ\[XɑΉCX^X`̏ꍇ
			// VCX^X쐬ēo^
			library = new OperatorLibrary(pfx);
			instances.put(pfx, library);
		}

		return library;
	}
	/**
	 * ZqnhԂD
	 * @param name Zq(Kꂽ)
	 * @return Zqnh(null:YȂ)
	 */
	public Operation getOperationOf(String name) {
		// w肳ꂽZqɊYNXt@CT
		Class clazz = (Class)opedic.get(name);
		if(clazz == null) {
			// YȂ
			return null;
		}

		// VZq̃nhԂD
		try {
			Operation opr = (Operation)clazz.newInstance();
			return opr;
		} catch(Exception e) {
			// s
			return null;
		}
	}
}
