/*
 * LOGICAL-PARADOX.ORG
 * Copyright (C)2005 satoshi akabane(akabane@logical-paradox.org)
 * $Id: BasicLanguageException.java,v 1.1 2006/10/21 08:55:30 akabane Exp $
 */
package org.logical_paradox.petitbasic.runtime.exception;

/**
 * BASICG[
 * @author satoshi akabane@logical-paradox.org
 * @version $Revision: 1.1 $
 */
public class BasicLanguageException extends Exception {
	/** suid */
	private static final long serialVersionUID = 261094705283738397L;
	/** G[R[h(BASIC) */
	private final int errorCode;
	/** G[sԍ(-1:_CNg[h) */
	private int lineno = -1;

	/**
	 * RXgN^D
	 * @param ec G[R[h
	 */
	public BasicLanguageException(int ec) {
		errorCode = ec;
	}
	/**
	 * RXgN^D
	 * @param ec G[R[h(BASIC)
	 * @param lno G[̔sԍ
	 */
	public BasicLanguageException(int ec, int lno) {
		errorCode = ec;
		lineno = lno;
	}
	/**
	 * RXgN^D
	 * @param ec G[R[h(BASIC)
	 * @param lno G[̔sԍ
	 * @param e ɂȂO(InternalErrorȂǂ̏ꍇ)
	 */
	public BasicLanguageException(int ec, int lno, Exception e) {
		super(e);
		errorCode = ec;
		lineno = lno;
	}
	/**
	 * G[R[hԂD
	 * @return G[R[h(BASIC)
	 */
	public int getErrorCode() {
		return errorCode;
	}
	/**
	 * sԍ㏑D
	 * @param lno sԍ
	 */
	public void setLineno(int lno) {
		lineno = lno;
	}
	/**
	 * sԍԂD
	 * @return sԍ
	 */
	public int getLineno() {
		return lineno;
	}
}
