/*
 * $Id: Mathpack.java,v 1.47 2008/10/26 15:20:19 akabane Exp $
 * Copyright (c) 2006 LOGICAL-PARADOX.ORG
 */
package org.logical_paradox.petitbasic.runtime.mathpack;

import java.util.HashMap;

import org.logical_paradox.petitbasic.runtime.BasicRuntimeConfig;
import org.logical_paradox.petitbasic.runtime.ErrorCodeConstant;
import org.logical_paradox.petitbasic.runtime.exception.BasicLanguageException;
import org.logical_paradox.petitbasic.var.Variable;

/**
 * _ZpbP[W MathpackD
 * java͂܂Ƃȕ_̌vZłȂ悤Ȃ̂ŁCdȂpbP[WD
 * ZɕKvȏsȂCuD
 * @author satoshi akabane@logical-paradox.org
 * @version $Revision: 1.47 $
 */
public final class Mathpack {
	/** BASIC^CRtBO */
	private BasicRuntimeConfig config;
	/** ~ */
	private Real pi;
	/** log(2)̒l */
	private Real LN2;
	/** SIN֐̋ߎle[u */
	private HashMap tblSin = new HashMap();
	
	/** _V[h X */
	private int X = XORSHIFT_CONST_X;
	/** _V[hY */
	private int Y = XORSHIFT_CONST_Y;
	/** _V[h W */
	private int W = XORSHIFT_CONST_W;
	/** _V[h Z */
	private int Z = XORSHIFT_CONST_Z;

	/** xorshift萔 X */
	private static final int XORSHIFT_CONST_X = 123456789;
	/** xorshift萔 Y */
	private static final int XORSHIFT_CONST_Y = 362436069;
	/** xorshoft萔 W */
	private static final int XORSHIFT_CONST_W = 88675123;
	/** xorshift萔 Z */
	private static final int XORSHIFT_CONST_Z = 521288629;

	/**
	 * RXgN^D
	 * @param c BASIC^CRtBO[V
	 */
	private Mathpack(BasicRuntimeConfig c) {
		config = c;
		if(config.mathpackInitOnStartup) {
			// X^[gAbvmathpack郂[h̏ꍇ̂ݎ{
			init();
		}
	}
	/**
	 * D
	 * ̒萔Oɍ쐬ĂD<br>
	 * RtBO[V̐ݒɂĂ͏Ȃꍇ̂Œӂ邱
	 */
	protected void init() {
		// ~vZ
		fp_PI();
		// log(2)vZ
		fp_LOG2();
	}
	/**
	 * LbVD
	 *
	 */
	public void initCache() {
		tblSin.clear();
	}
	/**
	 * mathpack̃CX^X쐬D
	 * @param config RtBO[V
	 * @return VCX^X
	 */
	public static final Mathpack getInstance(BasicRuntimeConfig config) {
		return new Mathpack(config);
	}
	/**
	 * Pxl쐬D
	 * @param value Pxl
	 */
	public Real floatValue(String value) {
		return new Real(Real.PRECISION_SINGLE, config.singlePrecisionFigures, value);
	}
	/**
	 * Pxl쐬D
	 * @param value Pxl
	 */
	public Real floatValue(float value) {
		return new Real(config.singlePrecisionFigures, value);
	}
	/**
	 * {xl쐬D
	 * @param {xl
	 */
	public Real doubleValue(String value) {
		return new Real(Real.PRECISION_DOUBLE, config.doublePrecisionFigures, value);
	}
	/**
	 * {xl쐬D
	 * @param {xl
	 */
	public Real doubleValue(double value) {
		return new Real(config.doublePrecisionFigures, value);
	}
	/**
	 * Px^ϐ쐬D
	 * @param varname ϐ
	 * @param value l
	 * @return ϐ
	 */
	public Variable floatVariable(String varname, String value) {
		Real real = floatValue(value);
		Variable var = new Variable(varname, real);
		return var;
	}
	/**
	 * {x^ϐ쐬D
	 * @param varname ϐ
	 * @param value l
	 * @return ϐ
	 */
	public Variable doubleVariable(String varname, String value) {
		Real real = doubleValue(value);
		Variable var = new Variable(varname, real);
		return var;
	}
	/**
	 * ^ϐ쐬D
	 * @param varname ϐ
	 * @param value l
	 * @return ϐ
	 */
	public Variable intVariable(String varname, String value) {
		Variable var = new Variable(varname, Integer.parseInt(value));
		return var;
	}
	/**
	 * ^ϐ쐬D
	 * @param varname ϐ
	 * @param value l
	 * @return ϐ
	 */
	public Variable stringVariable(String varname, String value) {
		Variable var = new Variable(varname, value);
		return var;
	}
	/**
	 * ^ϐ쐬D
	 * @param varname ϐ
	 * @param value l
	 * @return ϐ
	 */
	public Variable realVariable(String varname, Real value) {
		Variable var = new Variable(varname, value);
		return var;
	}
	/**
	 * {x^ɕϊD
	 * {xl^ꂽꍇCRs[ꂽʂ̃CX^XPɕԋpD
	 * @param value l(Px)
	 * @return ϊꂽl
	 */
	public Real fp_CDBL(Real value) {
		if(value.precision == Real.PRECISION_DOUBLE) {
			return new Real(value);
		}
		return doubleValue(value.toString(false));
	}
	/**
	 * {x^ɕϊD
	 * @param value 
	 * @return ϊꂽl
	 */
	public Real fp_CDBL(long value) {
		return doubleValue("" + value);
	}
	/**
	 * Px^ɕϊD
	 * @param value 
	 * @return ϊꂽl
	 */
	public Real fp_CSNG(long value) {
		return floatValue("" + value);
	}
	/**
	 * Px^ɕϊD
	 * Pxl^ꂽꍇCRs[ꂽʂ̃CX^XPɕԋpD
	 * @param value ^({x)
	 * @return ϊꂽl
	 */
	public Real fp_CSNG(Real value) {
		if(value.precision == Real.PRECISION_SINGLE) {
			return new Real(value);
		}
		return floatValue(value.toString(true));
	}
	/**
	 * _m̉ZD
	 * @param v1 l1
	 * @param v2 l2
	 * @return vZ
	 */
	public Real fp_ADD(Real v1, Real v2) {
		if(v1.isPositive() != v2.isPositive()) {
			// 1Ƒ2̕قȂꍇCZɕϊ
			if(v1.isPositive() == false) {
				Real tmp = v2;
				v2 = v1;
				v1 = tmp;
			}
			// 2̕𐳂ɕϊ
			v2 = new Real(v2);
			v2.setPositive(true);

			return fp_SUB(v1, v2);
		}
		// KvłΐxϊsȂ
		if(v1.precision != Real.PRECISION_DOUBLE) {
			v1 = fp_CDBL(v1);
		}
		if(v2.precision != Real.PRECISION_DOUBLE) {
			v2 = fp_CDBL(v2);
		}

		// 킹
		Real[] values = adjustFraction(v1, v2);

		// ꂩ0̏ꍇ͉Ȃ
		if(values[0].isZero()) {
			return new Real(v2);
		} else if(values[1].isZero()) {
			return new Real(v1);
		}

		v1 = values[0];
		v2 = values[1];

		// ƂɉZsȂ
		Real value = doubleValue(0.0d);
		int fig = v1.fractionOccupied > v2.fractionOccupied ? v1.fractionOccupied : v2.fractionOccupied;
		int ov = 0;					// I[o[t[tO
		for(int loop = fig-1; loop >= 0; loop--) {
			int v = v1.fraction[loop] + v2.fraction[loop] + ov;
			ov = v >= 10 ? 1 : 0;
			v = v % 10;
			value.fraction[loop] = v;
		}
		// ̔
		value.setPositive(v1.isPositive() && v2.isPositive());

		// w̌vZ
		value.exponent = v1.exponent > v2.exponent ? v1.exponent : v2.exponent;
		// ӂꂪĂꍇ̏
		if(ov > 0) {
			// ŉʂ̌Ŏľܓ
			int previousExponent = value.exponent;
			value = fp_ROUND(value, value.fraction.length-1);
			if(previousExponent == value.exponent) {
				// ľܓ̌ʁCӂꂪȂꍇ
				// EփVtg
				value = _shiftToRight(value, 1);
			}
			// ŏʂ̌ɑ΂1ǉ(̋ǖʂŌӂꂷ邱Ƃ͂Ȃ͂)
			value.fraction[0] += 1;
			// ɂĂCӂꂪ
			value.exponent++;
		}

		// ̗L̐ݒ
		value.setFractionOccupied(v1.fraction.length);

		return value;
	}
	/**
	 * _m̌ZD
	 * @param v1 l1
	 * @param v2 l2
	 * @return vZ
	 */
	public Real fp_SUB(Real v1, Real v2) {
		if(v1.isPositive() != v2.isPositive()) {
			// 1Ƒ2̕قȂꍇC2̕𔽓]ĉZ
			Real real = new Real(v2);
			real.positive = !real.positive;
			return fp_ADD(v1, real);
		}
		// KvłΐxϊsȂ
		if(v1.precision != Real.PRECISION_DOUBLE) {
			v1 = fp_CDBL(v1);
		}
		if(v2.precision != Real.PRECISION_DOUBLE) {
			v2 = fp_CDBL(v2);
		}

		if(fp_CMPR(v1, v2) == 0) {
			return doubleValue(0.0d);
		}

		// vZʂ̕Ǝw쐬
		boolean sign = v1.isPositive();
		int expr = v1.exponent > v2.exponent ? v1.exponent : v2.exponent;

		// 𐳂ɕϊ
		v1 = new Real(v1);
		v2 = new Real(v2);
		v1.setPositive(true);
		v2.setPositive(true);

		// 召r(12傫ꍇC̏Ԃւ)
		if(fp_CMPR(v1, v2) < 0) {
			Real tmp = v1;
			v1 = v2;
			v2 = tmp;
			// 1Ƒ2ꍇ́C]
			sign = !sign;
		}

		// 킹
		Real[] values = adjustFraction(v1, v2);

		if(values[1].isZero()) {
			v1.setPositive(sign);
			return v1;
		}

		v1 = values[0];
		v2 = values[1];

		// ƂɌZsȂ
		Real value = doubleValue(0.0d);
		int fig = v1.fractionOccupied > v2.fractionOccupied ? v1.fractionOccupied : v2.fractionOccupied;
		int cy = 0;			// LtO

		for(int loop = fig-1; loop >= 0; loop--) {
			int p1 = v1.fraction[loop];
			int p2 = v2.fraction[loop];
			int p = 0;
			if(p1 - cy >= p2) {
				// ̌ZɂȂȂꍇ͂̂܂܌ZCLtO0ɖ߂
				p = p1 - cy - p2;
				cy = 0;
			} else {
				// ̌ZɂȂꍇČׂ10؂Ă
				p = (10 - cy) - p2 + p1;
				cy = 1;
			}
			value.fraction[loop] = p;
		}

		// \̂ŁC[TvXsȂ
		int decreased = suppressZero(value);

		// ̕w猸Z
		expr -= decreased;

		// Ǝw̓
		value.exponent = expr;
		value.setPositive(sign);

		// ̗L̍Đݒ
		value.setFractionOccupied(value.fraction.length);

		return value;
	}
	/**
	 * _m̏ZD
	 * @param v1 l1
	 * @param v2 l2
	 * @return vZ
	 */
	public Real fp_MUL(Real v1, Real v2) {
		// KvłΐxϊsȂ
		if(v1.precision != Real.PRECISION_DOUBLE) {
			v1 = fp_CDBL(v1);
		}
		if(v2.precision != Real.PRECISION_DOUBLE) {
			v2 = fp_CDBL(v2);
		}

		if(v1.fractionOccupied < v2.fractionOccupied) {
			// ̒Zق搔Ƃ
			Real tmp = v1;
			v1 = v2;
			v2 = tmp;
		}
		Real value = doubleValue(0.0d);

		StringBuffer columnShift = new StringBuffer();
		for(int i = v2.fractionOccupied-1; i >= 0; i--) {
			int n = v2.fraction[i];
			int ov = 0;
			StringBuffer sb = new StringBuffer();
			for(int j = v1.fractionOccupied-1; j >= 0; j--) {
				int m = v1.fraction[j];
				int valueOfColumn = n * m + ov;
				ov = valueOfColumn / 10;
				valueOfColumn %= 10;
				sb.insert(0, "" + valueOfColumn);
			}
			// ӂꕪ̏
			if(ov > 0) {
				sb.insert(0, "" + ov);
			}
			// ␳
			sb.append(columnShift);
			// Z
			value = fp_ADD(value, new Real(doubleValue(sb.toString())));

			// 1Vtg
			columnShift.append("0");
		}
		// 
		value.setPositive(v1.isPositive() == v2.isPositive());

		// w̌vZ
		int v1p = v1.fractionOccupied - (v1.exponent+1);
		int v2p = v2.fractionOccupied - (v2.exponent+1);
		int expr = value.exponent - (v1p + v2p);
		value.exponent = expr;

		return value;
	}
	/**
	 * _m̏ZD
	 * @param v1 l1
	 * @param v2 l2
	 * @return vZ
	 */
	public Real fp_DIV(Real v1, Real v2) {
		if(v1.fraction[0] == 0) {
			// 0ŊĂ0ł
			return doubleValue(0.0d);
		} else if(v2.fraction[0] == 0) {
			// 0Z
			return null;
		}

		// KvłΐxϊsȂ
		if(v1.precision != Real.PRECISION_DOUBLE) {
			v1 = fp_CDBL(v1);
		}
		if(v2.precision != Real.PRECISION_DOUBLE) {
			v2 = fp_CDBL(v2);
		}

		/*-----------------------------------------------------
		 * ϐ̏
		 *----------------------------------------------------*/
		Real quot = doubleValue(0.0d);								// 
		Real divisor = new Real(v2);								// 
		divisor.setPositive(true);									// ͐ɂĂ
		Real dividend = doubleValue(0.0d);							// 폜
		int digitpos = 0;											// 낵ʒu
		int digitstore = 0;											// 낵ʒu
		int quotpos = 0;											// i[ʒu
		int fractions = quot.fraction.length;						// ̒
		divisor.exponent = countFigures(divisor) -1;				// ̏_
		boolean loopf = true;
		int expo = v1.exponent - v2.exponent;						// ̎w
		expo -= isFractionBig(v2, v1);								// w킹ۂɁC폜傫1}CiX
		int overflow = -1;											// ŉʌ̏(I[o[t[)

		/*-----------------------------------------------------
		 * Ẑ̂̃[v
		 *----------------------------------------------------*/
	loop:
		while(loopf) {
			int divisorFigures = countFigures(divisor);				// ̌
			dividend.exponent = dividend.fraction[0] == 0 ?	-1		// 1ڂ낵ۂɎw0ɂ鏈u
								: dividend.exponent;
			int divFigures = countFigures(dividend);				// 폜݂̌̌擾
			digitstore = divFigures;								// 낵ʒuČvZ(폜̖[)
			int guess = 0;											// l

			// ̐擪1폜̐擪1菬ꍇC1]vɌ낷
			int n = getNextFraction(dividend, v1, digitpos);
			boolean more = divisor.fraction[0] > n ||
							(divisorFigures == divFigures);			// ȂƂ1͉낷߂̏ - K
			divisorFigures += more ? 1 : 0;

			/*----------------------------------------
			 * 킹̃[v
			 *---------------------------------------*/
			while(divFigures < divisorFigures) {
				dividend = copyFraction(digitpos, 1, v1, digitstore, dividend);
				int q = digitpos < fractions ? v1.fraction[digitpos++] : 0;
				if(q > 0 || digitstore > 0) {
					// 낷̒l1ȏォC̓r'0'̏ꍇ͌Ƃĉ낷
					dividend.exponent++;
					digitstore++;
					divFigures++;
				}
				if(quotpos > 0 &&
					(
						(divFigures < divisorFigures) ||
						(divFigures == divisorFigures && fp_CMPR(dividend, divisor) < 0)
					)
				) {
					// ȊOŌsĂꍇ͏='0'Ƃ
					// ȏi[łȂꍇ͏I(I[o[t[Ȃ)
					if(quotpos >= fractions) {
						loopf = false;
						break loop;		// ֒fgoto!
					} else {
						quot.fraction[quotpos++] = 0;
					}
				}
				if(divFigures == divisorFigures && fp_CMPR(dividend, divisor) < 0) {
					// ŏIɂāC폜ˑRƂđ傫ꍇ͂1낷
					more = true;
					divFigures--;
				}
			}

			guess = (more ? dividend.fraction[0]*10+dividend.fraction[1] : dividend.fraction[0]) / v2.fraction[0];
			Real subtractor = fp_MUL(divisor, doubleValue(guess));

			// Zl폜傫ꍇ́C
			while(fp_CMPR(dividend, subtractor) < 0) {
				// ␳
				subtractor = fp_SUB(subtractor, divisor);
				guess--;
			}

			if(quotpos < fractions) {
				dividend = fp_SUB(dividend, subtractor);			// 폜|Zl
				quot.fraction[quotpos++] = guess;					// i[
				quot.setFractionOccupied(quot.fraction.length);		// L̍Đݒ
			} else {
				overflow = guess;									// ŉʌ̒li[
				break;
			}

			/*---- [vI ----*/
			if(
				loopf == false ||									// ǂŃ[vIm肵Ă邩
				quotpos > fractions ||								// ȏ㏤i[łȂ
				(dividend.fraction[0] == 0 &&						// ]0
					digitpos >= v1.fractionOccupied)				// SĂ̌낵(=؂ꂽ)
			) {
				loopf = false;										// ̏𖞂ꍇ̓[vI
			}
		}

		/*-----------------------------------------------------
		 * 𓚂̊m
		 *----------------------------------------------------*/
		quot.setPositive(v1.isPositive() == v2.isPositive());		// (vĂΐƂ)
		quot.exponent = expo;										// w

		/*-----------------------------------------------------
		 * ӂ̏
		 *----------------------------------------------------*/
		if(overflow >= 5) {
			// I[o[t[ľܓʁC+1ꍇ͍ŉʌɑ΂ĉZ
			Real ov = doubleValue(0.0d);
			ov.fraction[0] = 1;
			ov.positive = quot.positive;
			ov.exponent = quot.exponent - (quot.fraction.length -1);

			quot = fp_ADD(quot, ov);
		}

		return quot;
	}
	/**
	 * _m̐ZD
	 * @param v1 l1
	 * @param v2 l2
	 * @return vZ
	 */
	public Real fp_DIVI(Real v1, Real v2) {
		// ʏ̏ZCo
		Real answer = fp_DIV(v1, v2);
		if(answer == null) {
			// division by zero
			return null;
		}
		answer = fp_FIX(answer);

		return answer;
	}
	/**
	 * _ׂ̂ԂD
	 * @param x 
	 * @param y w
	 * @return ׂ
	 */
	public Real fp_POW(Real x, Real y) {
		if(x.precision == Real.PRECISION_SINGLE) {
			x = fp_CDBL(x);
		}
		if(y.precision == Real.PRECISION_SINGLE) {
			y = fp_CDBL(y);
		}

		if("0".equals(x.toString())) {
			if(y.positive == false || "0".equals(y.toString())) {
				return doubleValue(1.0d);
			}
			return doubleValue(0.0d);
		}

		if(y.toString().indexOf('.') < 0) {
			// yȂ
			if(y.isPositive() == false) {
				y = new Real(y);
				y.positive = true;
				x = fp_DIV(doubleValue(1.0d), x);		// x = 1 / x;
			}
			Real value = doubleValue(1.0d);
			Real two = doubleValue(2.0d);
			Real expo = new Real(y);
			
			while(expo.fraction[0] > 0) {
				if(expo.isEven() == false) {
					// ̏ꍇ
					value = fp_MUL(value, x);			// r *= x;
				}
				expo = fp_DIVI(expo, two);				// n /= 2;
				x = fp_MUL(x, x);						// x *= x;
			}
			return value;
		} else {
			return fp_EXP(fp_MUL(y, fp_LOG(x)));		// exp(y*log(x));

		}
	}
	/**
	 * _̕ԂD
	 * @param v1 
	 * @return 
	 * @throws BasicLanguageException s
	 */
	public Real fp_SQRT(Real v1) throws BasicLanguageException {
		Real f1 = doubleValue(1.0d);
		Real f2 = null;
		Real f3 = null;
		Real f4 = null;
		Real d = doubleValue(2.0d);

		if("0".equals(v1.toString())) {
			// 0̕0
			return doubleValue(0.0d);
		}
		if(v1.isPositive() == false) {
			// ̐^ꂽꍇ͈s(Pʂɂ͑ΉĂȂ)
			throw new BasicLanguageException(ErrorCodeConstant.ILLEGAL_FUNCTION_CALL, -1);
		}
		
		do {
			f3 = f2;
			f2 = f1;
			f4 = fp_ADD(fp_DIV(v1, f1), f1);
			f1 = fp_DIV(f4, d);
		} while(fp_CMPR(f2, f1) != 0 && (f3 == null || fp_CMPR(f3, f1) != 0));

		return f1;
	}
	/**
	 * SIN֐̋ߎlԂD
	 * }N[WJɂߎ.
	 * @param x x(x)
	 * @return ߎl
	 */
	public Real fp_SIN(Real x) {
		if(x.precision != Real.PRECISION_DOUBLE) {
			// {xɕϊ
			x = fp_CDBL(x);
		}

		// 360x͈̔͂Ɋۂ߂
		x = fp_MOD(x, doubleValue(360.0d));
		// m肷(3, 4ی̏ꍇ͕)
		boolean s = fp_CMPR(x, doubleValue(180.0d)) > 0 ? false : true;
		s = s == (x.positive || x.isZero());

		// 180x͈̔͂Ɋۂ߂
		x = fp_MOD(x, doubleValue(180.0d));
		if(fp_CMPR(x, doubleValue(90.0d)) > 0) {
			// 90xȏ̏ꍇ
			x = fp_SUB(doubleValue(180.0d), x);
		}
		// ߎle[uǑvZʂ{
		Real v = (Real)tblSin.get(x.toString());
		if(v != null) {
			// 
			return v;
		}

		// xWAϊ
		x = fp_MUL(fp_DIV(x, doubleValue(180.0d)), fp_PI());

		// eϐ
		v = new Real(x);
		Real w = doubleValue(0.0d);
		int n = 1;
		Real r = doubleValue(1.0d);
		Real sign = doubleValue(-1.0d);
		Real p = null;
		while(true) {
			w = new Real(v);
			r = fp_MUL(fp_ADD(r, r), doubleValue(n * (2 * n +1)));
			p = fp_MUL(fp_DIV(sign, r), fp_POW(x, doubleValue((double)2 * n + 1)));
			v = fp_ADD(v, p);
			sign.positive = sign.positive == false;
			if(fp_CMPR(v, w) == 0) {
				// (ŉʌŎľܓC{x̌Ő؂̂)
				v = fp_ROUND(v, v.fractionOccupied-1);
				v.positive = true;
				v = omitt(v, config.doublePrecisionFigures);
				v.positive = s;
				tblSin.put(x.toString(), v);
				return v;
			}
			n++;
		}
	}
	/**
	 * COS֐̋ߎlԂD
	 * COŚCSIN90x炵̂ł邽߁CZoD<br>
	 * ܂}WɌvZ͂ȂCLbVSIN̂̂gpD
	 * @param x (x)
	 * @return ߎl
	 */
	public Real fp_COS(Real x) {
		// 360x͈̔͂Ɋۂ߂
		x = fp_MOD(x, doubleValue(360.0d));
		// m肷(2, 3ی̏ꍇ͕)
		boolean sign = fp_CMPR(x, doubleValue(90.0d)) > 0 && fp_CMPR(x, doubleValue(270)) < 0 ? false : true;
		sign = sign == (x.positive || x.isZero());

		// COS(x) = SIN(90-x)  ƎOŋ߂
		Real v = fp_SIN(fp_SUB(doubleValue(90.0), x));
		v.positive = sign;

		return v;
	}
	/**
	 * TAN֐̋ߎlԂD
	 * tan=sin/cosƂ̌狁߂D
	 * @param x (x)
	 * @return ߎl
	 */
	public Real fp_TAN(Real x) {
		return fp_DIV(fp_SIN(x), fp_COS(x));
	}
	/**
	 * lCsAƂ^2̑ΐԂD
	 * ̃\bh́CMATHPACKł̂ݎgpD
	 * @return log(2)̋ߎl
	 */
	protected Real fp_LOG2() {
		if(LN2 != null) {
			return LN2;
		}
		int m = 1;
		int lim = 16;		// 臒l=16
		Real two = doubleValue(2.0d);
		Real value = doubleValue(0.0d);

		for(int n = 1; n < lim; n++) {
			Real a = doubleValue(2 * n -1);
			Real b = 
				fp_DIV(two,
					fp_MUL(a, fp_POW(doubleValue(2 * m + 1), a))
				);
			if(b.isZero()) {
				// ȏZĂӖȂ
				break;
			}
			value = fp_ADD(value, b);
		}
		
		LN2 = value;
		return LN2;
	}
	/**
	 * lCsAƂ^x̑ΐԂD
	 * @param x ^
	 * @return ߎl
	 */
	public Real fp_LOG(Real x) {
		Real error = doubleValue(-1.0d);
		if(fp_CMPR(x, doubleValue(0.0d)) <= 0) {
			// x܂0̏ꍇ̓G[Ƃ(Illegal function callȂǂɂ邱)
			return error;
		}
		Real ln2 = fp_LOG2();
		Real one = doubleValue(1.0d);
		Real two = doubleValue(2.0d);
		Real r = doubleValue(0.0d);
		Real n = doubleValue(1.0d);
		Real b = new Real(r);
		Real a = doubleValue(0.0d);

		if(fp_CMPR(x, two) == 0) {
			// x2̏ꍇ͉Ȃ
			return ln2;
		}

		// 1  x  2Ƃ邽߂̕␳
		while(fp_CMPR(x, two) >= 0) {
			x = fp_DIV(x, two);
			r = fp_ADD(r, ln2);
		}
		while(fp_CMPR(x, one) < 0) {
			x = fp_MUL(x, two);
			r = fp_SUB(r, ln2);
		}
		
		x = fp_DIV(fp_SUB(x, one), fp_ADD(x, one));
		a = fp_MUL(two ,x);
		x = fp_MUL(x, x);
		
		do {
			b = r;
			r = fp_ADD(r, fp_DIV(a, n));
			a = fp_MUL(a, x);
			n = fp_ADD(n, two);
		} while(fp_CMPR(b, r) != 0);

		return r;
	}
	/**
	 * Rΐ̒nԂD
	 * @param v w
	 * @return ߎl
	 */
	public Real fp_EXP(Real v) {
		// w0Ȃ1.0Ԃ
		if(v.isZero()) {
			return doubleValue(1.0d);
		}

		Real x = new Real(v);
		Real r = doubleValue(1.0d);
		Real before = doubleValue(1.0d);
		Real b = null;
		Real n = doubleValue(1.0d);
		int a = 2;
		do {
			before = r;
			b = fp_DIV(x, n);						// r += (x^n)/n!
			n = fp_MUL(n, doubleValue(a++));		// n!
			x = fp_MUL(x, v);						// x^n

			r = fp_ADD(r, b);
		} while(fp_CMPR(before, r) != 0 || b.isZero());

		return r;
	}
	/**
	 * _̐ΒlԂD
	 * @param v1 l1 
	 * @return l1̐Βl
	 */
	public Real fp_ABS(Real v1) {
		Real answer = new Real(v1);
		answer.setPositive(true);

		return answer;
	}
	/**
	 * _̏]ԂD
	 * @param v1 q
	 * @param v2 
	 * @return ]
	 */
	public Real fp_MOD(Real v1, Real v2) {
		if(v1.isZero() && v2.isZero()) {
			return doubleValue(0.0d);
		}
		
		Real x = fp_ABS(fp_DIV(v1, v2));
		Real y = fp_ABS(v2);
		Real z = fp_MUL(fp_FIX(x), y);		// v1v2͐̐Ȃ̂ŁC_ȉ͐؂̂Ăőv({INT)
		if(v1.positive) {
			return fp_SUB(v1, z);
		} else {
			return fp_ADD(v1, z);
		}
	}
	/**
	 * w肳ꂽŉľܓD
	 * 1ڂł̎ľܓ͕s\łD
	 * @param v1 
	 * @param fp ̌(1ȏ)
	 * @return ľܓꂽl
	 */
	protected Real fp_ROUND(Real v1, int fp) {
		// ̌̋e͈͂𒴂Ăꍇ̓G[ƂD
		if(fp < 0) {
			return doubleValue(0.0d);
		} else if(v1.fraction.length <= fp) {
			return new Real(v1);
		}
		Real real = new Real(v1);
		boolean up = false;				// ӂtO
		boolean first = true;				// tO
		int occ = real.fractionOccupied;	// ݂̉p

		// w茅ȍ~͑S0
		for(int i = fp+1; i < real.fraction.length; i++) {
			real.fraction[i] = 0;
		}

		do {
			int v = real.fraction[fp];
			if(first == true) {
				// ľܓ̏(Ώۂ͈̌ꗥ'0'ɂȂ)
				real.fraction[fp] = 0;
				up = v >= 5;
				first = false;
			} else {
				// ӂꂪꍇ̏
				v += up == true ? 1 : 0;
				up = v >= 10;
				v = v % 10;
				real.fraction[fp] = v;
			}
			fp--;
		} while(fp >= 0 && up == true);

		// ̌Jオ肪ǂ
		if(up == true) {
			// 1Vtg
			real = _shiftToRight(real, 1);
			// ŏʂ̌ɑ΂'1'ݒ肷
			real.fraction[0] = 1;
			real.exponent++;
		}
		// ̗ptOČvZ
		real.setFractionOccupied(occ);
		return real;
	}
	/**
	 * _𐮐ɕϊD
	 * w肳ꂽl𒴂Ȃő̐ɕϊD
	 * ӂȂǂŕϊłȂꍇCnullԋpD
	 * @param v1 
	 * @return ϊꂽl
	 */
	public Long fp_INT(Real v1) {
		Real value = new Real(v1);
		boolean positive = value.isPositive();
		value.setPositive(true);

		// _𕶎ɕϊ
		String string = value.toString(false);

		/*
		 * _̎̈ʒủ擾
		 */
		int pos = string.indexOf(".");
		boolean shift = false;
		if(pos >= 0) {
			shift = true;
			// _ȉ؂̂Ă
			string = string.substring(0, pos);
		}

		// قǏǉD
		string = (positive ? "" : "-") + string;

		Long answer = null;
		try {
			// ɕϊ
			answer = Long.valueOf(string);
			long lv = answer.longValue();
			if(shift && positive == false) {
				lv--;
			}
			answer = new Long(lv);
		} catch(NumberFormatException e) {
			// ϊɎs
		}

		return answer;
	}
	/**
	 * _݂̐̂𒊏oD
	 * Pɏ̐؂̂ĂsȂ̂݁D
	 * @param v1 
	 * @return 
	 */
	public Real fp_FIX(Real v1) {
		Real value = doubleValue(0.0d);

		if(v1.exponent < 0) {
			// Ɏw̏ꍇCǂʂ0
			return value;
		}
		int loopcnt = v1.exponent +1;
		loopcnt = loopcnt < value.fraction.length-1 ? loopcnt : value.fraction.length-1;

		for(int i = 0; i < loopcnt; i++) {
			value.fraction[i] = v1.fraction[i];
		}
		value.exponent = v1.exponent;
		value.positive = v1.positive;

		value.setFractionOccupied(value.fraction.length);

		return value;
	}
	/**
	 * 1Ƒ2rD
	 * @param v1 1
	 * @param v2 2
	 * @return v1 == v2 :0 / v1 > v2 :1 / v1 < v2 :-1
	 */
	public int fp_CMPR(Real v1, Real v2) {
		// 1Ƒ2̎xقȂꍇC{xɕϊ
		if(v1.precision != v2.precision) {
			v1 = fp_CDBL(v1);
			v2 = fp_CDBL(v2);
		}
		// ̔r
		boolean v1sign = v1.isPositive() || v1.fraction[0] == 0;
		boolean v2sign = v2.isPositive() || v2.fraction[0] == 0;
		if(v1sign == true && v2sign == false) {
			return 1;
		} else if(v1sign == false && v2sign == true) {
			return -1;
		}

		// ǂ炩0ꍇ̔r(vĂ邱ƂO)
		if(v1.fraction[0] != v2.fraction[0]) {
			if(v1.fraction[0] == 0) {
				return v1sign == true ? -1 : 1;
			} else if(v2.fraction[0] == 0) {
				return v1sign == true ? 1 : -1;
			}
		}
		// ꍇCw̔r
		int v1exp = v1.exponent;
		int v2exp = v2.exponent;
		if(v1exp > v2exp) {
			return 1;
		} else if(v1exp < v2exp) {
			return -1;
		}

		// wꍇC̔r
		for(int i = 0; i < v1.fraction.length; i++) {
			int v1p = v1.fraction[i];
			int v2p = v2.fraction[i];
			if(v1p > v2p) {
				return 1;
			} else if(v1p < v2p) {
				return -1;
			}
		}
		// Sv
		return 0;
	}
	/**
	 * ~ԂD
	 * ~BBP formula for piɂvZD
	 * xvZꂽʂ̓LbVD
	 * @return ~
	 */
	public Real fp_PI() {
		if(pi != null) {
			return pi;
		}

		Real before = null;
		Real ONE = doubleValue(1.0d);
		Real TWO = doubleValue(2.0d);
		Real FOUR = doubleValue(4.0d);
		Real FIVE = doubleValue(5.0d);
		Real SIX = doubleValue(6.0d);
		Real SIXTEEN = doubleValue(16.0d);
		Real EIGHT = doubleValue(8.0d);
		pi = doubleValue(0.0d);
		Real ek = doubleValue(0.0d);
		int k = 0;
		
//		pi +=
//			(1 / pow(16.0, k)) * (
//				(4 / (ek + 1)) - (2 / (ek + 4)) - (1 / (ek + 5)) - (1 / (ek + 6))
//			);
		do {
			before = pi;
			pi = fp_ADD(pi,
					fp_MUL(
						fp_DIV(ONE, fp_POW(SIXTEEN, doubleValue(k))),
						(
							fp_SUB(
							fp_SUB(
							fp_SUB(
								fp_DIV(FOUR, fp_ADD(ek, ONE)),
								fp_DIV(TWO, fp_ADD(ek, FOUR))
							),
								fp_DIV(ONE, fp_ADD(ek, FIVE))
							),
								fp_DIV(ONE, fp_ADD(ek, SIX))
							)
						)
					)
				);
			ek = fp_ADD(ek, EIGHT);
			k++;
		} while(fp_CMPR(before, pi) != 0);

		return pi;
	}
	/**
	 * l[𔭐D<br>
	 * xorshiftɂ.<br/>
	 * ͈̔͂0.0x1.0ƂȂD<br>
	 * @return l[
	 */
	public Real fp_RND() {
		int t = X ^ ((X << 11));
		X = Y;
		Y = Z;
		Z = W;
		
		int nextLong = (W = (W ^ (W >>> 19)) ^ (t ^ (t >>> 8)));
		Real nextDouble =			// (1.0 / LONG_MAX) * nextLong;
				fp_MUL(doubleValue("" + nextLong),
						fp_DIV(doubleValue(1.0d), doubleValue("" + Integer.MAX_VALUE))
				);

		// ʂ͏ɐ̐ŕԂ
		nextDouble.setPositive(true);

		return nextDouble;
	}
	/**
	 * nB
	 * @param seed _V[h
	 */
	public void fp_RANDOMIZE(Long seed) {
		X = (int)seed.longValue();
		Y = XORSHIFT_CONST_Y;
		W = XORSHIFT_CONST_W;
		Z = XORSHIFT_CONST_Z;
	}
	/**
	 * 錅ȉ؂̂Ă_𐶐ĕԂD<br>
	 * z֐̋ߎlȂǂ̖x̂ƂŎ邽߂ɎgpD<br>
	 * WJ܂ƂɂĂƁCƏIȂ߁D
	 * @param value ؂̂đΏۂ̕_
	 * @param figures L
	 * @return wL݂̂ێ镂_
	 */
	protected Real omitt(Real value, int figures) {
		String number = value.toString();
		figures = number.length() > figures ? figures : number.length();
		number = number.substring(0, figures);

		return new Real(Real.PRECISION_DOUBLE, config.doublePrecisionFigures, number);
	}
	/**
	 * 킹D
	 * @param v1 l1
	 * @param v2 l2
	 * @return 킹ĕ␳ꂽl([0]:v1 [1]:v2)
	 */
	protected Real[] adjustFraction(Real v1, Real v2) {
		Real[] reals = new Real[2];
		int expdiff = v1.exponent - v2.exponent;	// l1ƒl2̎w̍

		if(expdiff == 0) {
			// 1̎wƑ2̎włꍇ
			// ȂňԂD
			reals[0] = v1;
			reals[1] = v2;
			return reals;
		}
		if(expdiff < 0) {
			expdiff = -expdiff;
			// v1 < v2̏ꍇv1␳
			v1 = fp_ROUND(v1, v1.fraction.length - expdiff);
			v1 = _shiftToRight(v1, expdiff);
		} else {
			// v1 > v2̏ꍇv2␳
			v2 = fp_ROUND(v2, v2.fraction.length - expdiff);
			v2 = _shiftToRight(v2, expdiff);
		}

		reals[0] = v1;
		reals[1] = v2;

		return reals;
	}
	/**
	 * ̐擪'0'čĊi[D
	 * @param value [TvXΏےl
	 * @return ۂɏꂽ
	 */
	protected int suppressZero(Real value) {
		int count = 0;
		int figures = 0;
		boolean fixed = false;
		while(count < value.fraction.length) {
			if(fixed == false) {
				if(value.fraction[count] > 0) {
					fixed = true;
					figures = count;
				}
			}
			if(fixed == true) {
				// ߂
				value.fraction[count - figures] = value.fraction[count];
			}
			count++;
		}
		// ĉȂȂ'0'ŏ
		for(int i = value.fraction.length - figures; i < value.fraction.length; i++) {
			value.fraction[i] = 0;
		}
		return figures;
	}
	/**
	 * _̌ԂD
	 * @param x 
	 * @return 
	 */
	protected int countFigures(Real x) {
		int fractionOccupied = x.fractionOccupied;
		return fractionOccupied > x.exponent+1 ? fractionOccupied : x.exponent +1;
	}
	/**
	 * ̃Rs[sȂD
	 * Rs[牽낹ȂȂꍇC0낷
	 * @param idx Rs[Jnʒu
	 * @param len 
	 * @param from Rs[
	 * @param to Rs[
	 * @param pos Rs[Jnʒu
	 * @return Rs[(to)
	 */
	protected Real copyFraction(int idx, int len, Real from, int pos, Real to) {
		while(
			len > 0 &&
			pos < to.fraction.length
		) {
			to.fraction[pos++] = idx < from.fraction.length ? from.fraction[idx++] : 0;
			len--;
		}
		// gp̈̍ČvZ
		to.setFractionOccupied(to.fraction.length);

		return to;
	}
	/**
	 * 폜̐擪1̐ԂD
	 * ]0łȂꍇC]̐擪1ԋpC]0̏ꍇ
	 * 폜̌낵ʒuȍ~ōŏɓoꂷ0ȊO̐ԂD<br>
	 * 폜̎c肪S0̏ꍇC0ԂD
	 * @param dividend ]
	 * @param v1 폜
	 * @param digitpos 낵ʒu
	 * @return 낳l
	 */
	protected int getNextFraction(Real dividend, Real v1, int digitpos) {
		if(dividend.fraction[0] > 0) {
			return dividend.fraction[0];
		}
		while(digitpos < v1.fraction.length) {
			if(v1.fraction[digitpos] > 0) {
				return v1.fraction[digitpos];
			}
			digitpos++;
		}
		return 0;
	}
	/**
	 * ̏ȑ傫rD
	 * @param v1 l1
	 * @param v2 l2
	 * @return v1 > v2̏ꍇtrueCȊOfalse
	 */
	protected int isFractionBig(Real v1, Real v2) {
		int exp1 = v1.exponent;
		int exp2 = v2.exponent;
		boolean sign1 = v1.positive;
		boolean sign2 = v2.positive;

		v1.exponent = v2.exponent = 0;
		v1.positive = v2.positive = true;
		boolean big = fp_CMPR(v1, v2) > 0;

		v1.exponent = exp1;
		v2.exponent = exp2;
		v1.positive = sign1;
		v2.positive = sign2;

		return big ? 1 : 0;
	}
	/**
	 * w肳ꂽCEփVtgD
	 * ʂƂĕԋpIuWFNǵCKReal^Ƃ
	 * ł͂ȂƂɒӂ邱ƁD<br>
	 * ̃\bh́ClZ̓rŌĂяoȂǂ邱ƁD
	 * @param v1 
	 * @param shiftCount Vtg錅
	 * @return Vtgꂽl
	 */
	protected Real _shiftToRight(Real v1, int shiftCount) {
		Real value = new Real(v1);
		if(shiftCount <= 0) {
			return value;
		} else if(shiftCount >= value.fraction.length) {
			return doubleValue(0.0d);
		}
		int pos = value.fraction.length-1;
		int cnt = pos - shiftCount;
		while(cnt >= 0) {
			value.fraction[pos--] = value.fraction[cnt--];
		}
		// VtǧʂƂċ󂢂̈0ŃNA
		for(int i = 0; i < shiftCount; i++) {
			value.fraction[i] = 0;
		}
		// ̗LĐݒ肷
		value.setFractionOccupied(value.fraction.length);
		return value;
	}
}
