/*
 * LOGICAL-PARADOX.ORG
 * Copyright (C)2006 satoshi akabane(akabane@logical-paradox.org)
 * $Id: Variable.java,v 1.1 2006/12/06 17:55:16 akabane Exp $
 */
package org.logical_paradox.petitbasic.var;

import org.logical_paradox.petitbasic.lex.Token;
import org.logical_paradox.petitbasic.runtime.mathpack.Real;

/**
 * BASIC^Cɂϐ̓\
 * @author satoshi akabane@logical-paradox.org
 * @version $Revision: 1.1 $
 */
public class Variable {
	/** ^^Cv -  */
	public static final int VTYPE_INT = Token.VTYPE_INT;
	/** ^^Cv - Px */
	public static final int VTYPE_SGL = Token.VTYPE_SGL;
	/** ^^Cv - {x */
	public static final int VTYPE_DBL = Token.VTYPE_DBL;
	/** ^^Cv -  */
	public static final int VTYPE_STR = Token.VTYPE_STR;

	/** l^ */
	public final int valuetype;
	/** ϐ */
	public final String varname;
	/** l() */
	public long intvalue;
	/** l() */
	public Real realvalue;
	/** l() */
	public String strvalue;

	/**
	 * RXgN^D
	 * @param name ϐ
	 * @param value l
	 */
	public Variable(String name, long value) {
		varname = name;
		valuetype = Variable.VTYPE_INT;
		intvalue = value;
	}
	/**
	 * RXgN^D
	 * @param name ϐ
	 * @param real l
	 */
	public Variable(String name, Real real) {
		varname = name;
		realvalue = real;
		valuetype = real.getPrecision() == Real.PRECISION_SINGLE ? VTYPE_SGL : VTYPE_DBL;
	}
	/**
	 * RXgN^D
	 * @param name ϐ
	 * @param value l
	 */
	public Variable(String name, String value) {
		varname = name;
		valuetype = Variable.VTYPE_STR;
		strvalue = value;
	}
	/**
	 * ϐlݒ肷D
	 * BȌ^(ftHg^)w肵Ă͂ȂȂ
	 * @param token l
	 * @throws IllegalArgumentException ls
	 */
	public void setValue(Token token) {
		if(token.getType() != Token.TYPE_LITERAL || token.getValueType() == Token.VTYPE_DEF) {
			throw new IllegalArgumentException("lȊO܂̓ftHg^͎w肵Ă͂Ȃ܂");
		}
		switch(token.getValueType()) {
			case Token.VTYPE_INT:	intvalue = token.getIntValue(); break;
			case Token.VTYPE_SGL:
			case Token.VTYPE_DBL:	realvalue = token.getRealValue(); break;
			case Token.VTYPE_STR:	strvalue = token.getStrValue(); break;
			default:
				throw new IllegalArgumentException("sȒl^w肳܂");
		}
	}
	/**
	 * ̕ϐ̓e萔̃g[NɕϊĕԂD
	 * @return g[N
	 */
	public Token toToken() {
		Token token = new Token(Token.TYPE_LITERAL);

		switch(valuetype) {
			// Px^
			case VTYPE_SGL:
				token.setValueType(Token.VTYPE_SGL);
				token.setRealValue(realvalue);
				break;
			// {x^
			case VTYPE_DBL:
				token.setValueType(Token.VTYPE_DBL);
				token.setRealValue(realvalue);
				break;
			// ^
			case VTYPE_INT:
				token.setValueType(Token.VTYPE_INT);
				token.setIntValue(intvalue);
				break;
			// ^
			case VTYPE_STR:
				token.setValueType(Token.VTYPE_STR);
				token.setStrValue(strvalue);
				break;
			default:
				// 
				throw new IllegalStateException();
		}

		return token;
	}
}
