/*
 * $Id: NoiseGenerator.java,v 1.2 2008/03/16 15:11:52 akabane Exp $
 */
package org.logical_paradox.petitbasic.sound;

import java.util.Random;


/**
 * mCYWFl[^.
 * @author satoshi akabane@logical-paradox.org
 * @version $revision$
 */
public class NoiseGenerator extends WaveGenerator {
	private Random rand = new Random(System.currentTimeMillis());

	/**
	 * RXgN^.
	 * @param freq TvOg
	 */
	public NoiseGenerator(long freq) {
		super(freq);
	}
	/**
	 * TvOf[^𐶐B
	 * @return ꂽg`f[^(1)
	 */
	protected byte[] generateWaveData() {
		return null;
	}
	/**
	 * w莞ԕ̃TvOf[^𐶐B
	 * @param sec Kvb(P:b)
	 * @return TvOf[^
	 */
	public synchronized byte[] getWaveData(double sec) {
		// 1t[̃oCg
		int needLength = (int)(samplingFreqRate * sec);

		if(frequency < 0) {
			return new byte[needLength];
		}

		int len = 1;
		int ptr = 0;
		byte[] outdata = new byte[needLength];
		byte b = 0;
		byte c = 0;
		int cnt = 0;
		double yy = 1.0;
		while(ptr < outdata.length) {
			if(cnt % len == 0) {
				String d = "" + Math.abs(rand.nextInt());
				boolean sign = (d.charAt(0) & 1) == 0;
				b = (byte)(Math.abs(rand.nextInt()) % volume * (sign ? 1 : -1));
				yy = (double)(b - c) / len;
				c = b;
			}
			outdata[ptr++] = (byte)(b + yy * (cnt % len));
			cnt++;
		}
		return outdata;
	}
}
