/*
 * $Id: SinWaveGenerator.java,v 1.1 2008/02/06 16:17:33 akabane Exp $
 */
package org.logical_paradox.petitbasic.sound;

/**
 * TCgWFl[^.
 * @author satoshi akabane@logical-paradox.org
 * @version $revision$
 */
public class SinWaveGenerator extends WaveGenerator {
	/**
	 * RXgN^.
	 * @param freq TvOg
	 */
	public SinWaveGenerator(long freq) {
		super(freq);
	}
	/**
	 * TvOf[^𐶐B
	 * @return ꂽg`f[^(1)
	 */
	protected byte[] generateWaveData() {
		// wave.length = 1̃f[^
		// degree = ݂̊px
		// dd = 1oCg̊px
		byte[] f = new byte[(int)(samplingFreqRate / frequency)];
		double degree = 0.0;
		double dd = 360.0 / f.length;
		double v = 0.0;

		for(int i = 0; i < f.length; i++) {
			v = volume * Math.sin(Math.toRadians(degree));
			f[i] = (byte)Math.round((float)v);
			degree += dd;
		}
		return f;
	}
}
