/*
 * $Id: SoundDevice.java,v 1.7 2008/03/16 15:11:52 akabane Exp $
 */
package org.logical_paradox.petitbasic.sound;

import java.util.ArrayList;
import java.util.List;

import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.SourceDataLine;

/**
 * zTEhfoCXB
 * @author satoshi akabane@logical-paradox.org
 * @version $Revision: 1.7 $
 */
public class SoundDevice {
	/** g` - `g */
	public static final int WAVE_SQUARE = 1;
	/** g` - g */
	public static final int WAVE_SIN = 2;
	/** g` - mCY */
	public static final int WAVE_NOISE = 99;

	/** sǂ(true:sȂ / false:s) */
	public final boolean nowait;
	/** TvOg(Hz) */
	protected long samplingFreqRate;
	/** `l */
	protected int channels;
	/** \(msec) */
	protected long resolution;
	/** g`WFl[^ */
	protected WaveGenerator[] gens;
	/** ~LT[ */
	protected Mixer mixer;
	/** C */
	protected SourceDataLine line;
	/** I[fBItH[}bg */
	protected AudioFormat format;
	long delay = 2;

	private boolean disabled = true;

	/**
	 * RXgN^D
	 * @param freq TvOg
	 * @param ch `l
	 * @param res \
	 * @throws LineUnavailableException C̏Ɏs
	 */
	public SoundDevice(int freq, int ch, long res) throws LineUnavailableException {
		this(freq, ch, res, false);
	}
	/**
	 * RXgN^.
	 * @param freq TvOg
	 * @param ch `l
	 * @param res \
	 * @param nowait true:sȂ / false:s
	 * @throws LineUnavailableException C̏Ɏs
	 */
	public SoundDevice(int freq, int ch, long res, boolean nowait) throws LineUnavailableException {
		this.nowait = nowait;
		samplingFreqRate = freq;
		channels = ch;
		resolution = res;

		gens = new WaveGenerator[channels];
		for(int i = 0; i < gens.length; i++) {
			gens[i] = getWaveGenerator(WAVE_SQUARE, samplingFreqRate);
		}
		
		mixer = new Mixer();
		
		init();
	}
	/**
	 * TEhfoCXD
	 * @throws LineUnavailableException C̏Ɏs(o̓foCXȂȂ)
	 */
	protected void init() throws LineUnavailableException {
		format = new AudioFormat(samplingFreqRate, 8, 1, true, false);
		DataLine.Info info = new DataLine.Info(SourceDataLine.class, format);

		// CJ
		line = (SourceDataLine)AudioSystem.getLine(info);
	}
	/**
	 * `lԂD
	 * @return `l
	 */
	public int getChannels() {
		return channels;
	}
	/**
	 * g`p^[ݒ肷B
	 * @param channel `l
	 * @param wp g`p^[
	 */
	public void setWavePattern(int channel, int wp) {
		gens[channel] = getWaveGenerator(wp, samplingFreqRate);
	}
	/**
	 * zTEhfoCX̃TvOgԂB
	 * @return TvOg
	 */
	public long getSamplingFreqRate() {
		return samplingFreqRate;
	}
	/**
	 * `lɑ΂Ďgݒ肷B
	 * @param channel `lԍ(0`)
	 * @param freq o͎g
	 */
	public void setFrequency(int channel, double freq) {
		if(channel < 0 || channel >= gens.length) {
			// `lԍ̎w肪͈͊OłD
			throw new IllegalArgumentException();
		}
	
		// g`WFl[^ɑ΂ďo͎gݒ肷
		gens[channel].setFrequency(freq);
	}

	/**
	 * zTEhfoCXJnB
	 */
	public void enable() {
		if(line != null && !line.isOpen()) {
			try {
				line.open(format);
			} catch (LineUnavailableException e) {
				// TODO ꂽ catch ubN
				e.printStackTrace();
			}
		}
		if(disabled) {
			line.start();
			disabled = false;
		}
	}

	/**
	 * zTEhfoCXB
	 */
	public void disable() {
		disabled = true;

		if(line != null && line.isRunning() && line.isOpen()) {
			line.drain();
			line.flush();
			int bs = line.getBufferSize();
			while(line.available() < bs);
		}
		for(int i = 0; i < channels; i++) {
			mute(i);
		}
	}
	/**
	 * `lɑ΂ĕݒ肷B
	 * @param `lԍ(0`)
	 * @param dividerRatio 
	 */
	public void setDividerRatio(int channel, int dividerRatio) {
		setFrequency(channel, 111860.78125 / dividerRatio);
	}
	/**
	 * `l̔~B
	 * @param channel `lԍ(0`)
	 */
	public void mute(int channel) {
		setFrequency(channel, -1);
	}
	/**
	 * `lɑ΂ă{[ݒ肷B
	 * @param channel `lԍ(0`)
	 * @param vol o͉(0`255)
	 */
	public void setVolume(int channel, int vol) {
		if(channel < 0 || channel >= gens.length) {
			// `lԍ̎w肪͈͊OłD
			throw new IllegalArgumentException();
		}
	
		// g`WFl[^ɑ΂ďo͉ʂݒ肷
		gens[channel].setVolume(vol);
	}

	/**
	 * 1t[sB
	 * ̃\bhł́A1t[̃TvOf[^𐶐A
	 * Cɑ΂ďo͂<br/>
	 * zTEhfoCX璼ڎsȂ߁ATEho͂
	 * ɂ͉炩̃XbhIɂ̃\bhNKvB
	 * @throws InterruptedException ҂Ɋ荞݂
	 */
	public void proc() throws InterruptedException {
		if(disabled) {
			return;
		}
		long before = 0L;
		before = System.currentTimeMillis();
		int threshold = line.getBufferSize() - 4000;
	
		// e`lƂ̃TvOf[^擾(1t[)
		List waves = new ArrayList();
		byte[] d = null;
		for(int i = 0; i < channels; i++) {
			d = gens[i].getWaveData((double)resolution / 1000.0);
			if(d != null && d.length > 0) {
				waves.add(d);
			}
		}
		byte[][] data = (byte[][])waves.toArray(new byte[0][0]);
	
		// g`̍
		byte[] wave = mixer.mix(data);
		long waitsec = (resolution - delay) - (System.currentTimeMillis() - before);
		if(!nowait && waitsec > 0) {
			Thread.sleep(waitsec);
		}
		before = System.currentTimeMillis();
	
		while(line.available() < threshold);

		if(wave != null) {
			// C֏o͂
			line.write(wave, 0, wave.length);
		}
	}
	/**
	 * g`WFl[^쐬.
	 * @param wt g`^Cv
	 * @param freq TvOg
	 * @return g`WFl[^
	 */
	protected WaveGenerator getWaveGenerator(int wt, long freq) {
		WaveGenerator wg = null;
		switch(wt) {
			case WAVE_SQUARE:
				wg = new SquareWaveGenerator(freq);
				break;
			case WAVE_SIN:
				wg = new SinWaveGenerator(freq);
				break;
			case WAVE_NOISE:
				wg = new NoiseGenerator(freq);
				break;
			default:
				throw new IllegalArgumentException();
		}
		
		return wg;
	}
}