package org.logical_paradox.petitbasic.sound;
import java.awt.BorderLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

import org.logical_paradox.common.swing.Window;
import org.logical_paradox.common.swing.WindowPanel;

/*
 * $Id: SoundDeviceTest.java,v 1.1 2008/09/13 14:23:59 akabane Exp $
 */

public class SoundDeviceTest {
	/** 1bԂɕ`悷t[ */
	public static final int FPS = 50;
	public static final long TIMER = 1000 / FPS;

	public static final void main(String[] args) throws Exception {
		SoundDeviceWindowPanel panel = new SoundDeviceWindowPanel();
		Window window = new Window("sound device control v0.0", panel, 320, 128);

		panel.init();
		window.setResizable(false);
		window.setVisible(true);
	}

	static class SoundDeviceWindowPanel extends WindowPanel implements ActionListener, ChangeListener {
		/** VAo[WUID */
		private static final long serialVersionUID = 1627712713278935065L;
		private JCheckBox cb;
		private JButton btnStart = new JButton("START");
		private JButton btnStop = new JButton("STOP");

		private boolean playing = false;
		private Sound sound;
		private JSlider[] slider;
		private JCheckBox[] channelCb;

		public void init() {
			setLayout(new GridLayout(4, 1));

			JPanel mainPanel = new JPanel();
			
			cb = new JCheckBox(" noise ch.");
			cb.addActionListener(this);
			
			btnStart.addActionListener(this);
			btnStop.addActionListener(this);

			btnStop.setEnabled(false);

			mainPanel.setLayout(new GridLayout(1, 2));
			mainPanel.add(cb);
			mainPanel.add(btnStart);
			mainPanel.add(btnStop);

			slider = new JSlider[3];
			channelCb = new JCheckBox[3];

			for(int i = 0; i < slider.length; i++) {
				channelCb[i] = new JCheckBox("ch." + (i+1));
				channelCb[i].setSelected(true);
				channelCb[i].addActionListener(this);
				slider[i] = new JSlider(14, 2000);
				slider[i].setValue(440 + i * 20);
				slider[i].addChangeListener(this);
				JPanel p = new JPanel();
				p.setLayout(new BorderLayout());
				p.add(channelCb[i], BorderLayout.WEST);
				p.add(slider[i], BorderLayout.CENTER);
				add(p);
			}
			add(mainPanel);
			try {
				sound = new Sound(44100, 4, 10);
				sound.mute(3);
				sound.setWavePattern(3, Sound.WAVE_NOISE);
			} catch(Exception e) {
				e.printStackTrace();
			}
		}

		public void actionPerformed(ActionEvent e) {
			Object o = e.getSource();
			if(o == btnStart) {
				sound.open();
				for(int i = 0; i < channelCb.length; i++) {
					if(channelCb[i].isSelected()) {
						sound.setFrequency(i, slider[i].getValue());
					}
				}
				if(cb.isSelected()) {
					sound.setFrequency(3, 0);
				}
			} else if(o == btnStop) {
				sound.close();
			} else if(o == cb) {
				if(cb.isSelected()) {
					sound.setFrequency(3, 0);
				} else {
					sound.mute(3);
				}
				return;
			} else {
				for(int i = 0; i < channelCb.length; i++) {
					if(o == channelCb[i]) {
						if(channelCb[i].isSelected()) {
							sound.setFrequency(i, slider[i].getValue());
						} else {
							sound.mute(i);
						}
					}
				}
				return;
			}
			playing = !playing;
			btnStart.setEnabled(!playing);
			btnStop.setEnabled(playing);
		}

		public void stateChanged(ChangeEvent e) {
			if(sound.isOpen()) {
				for(int i = 0; i < channelCb.length; i++) {
					if(channelCb[i].isSelected()) {
						sound.setFrequency(i, slider[i].getValue());
					}
				}
				if(cb.isSelected()) {
					sound.setFrequency(3, 0);
				}
			}
		}
	}
}
