/*
 * $Id: WaveGenerator.java,v 1.7 2008/11/23 15:49:40 akabane Exp $
 */
package org.logical_paradox.petitbasic.sound;


public abstract class WaveGenerator {

	/** TvOg */
	protected long samplingFreqRate;
	/** o͎g */
	protected double frequency = -1.0;
	/** o͉ */
	protected int volume = 2;
	/** O̔g`̓rꍇC̈ʒu */
	private double offset = 0.0;
	private int count = 0;
	private byte[] f;

	private byte[] remain;
	private int count_s = 0;

	/**
	 * RXgN^B
	 * @param freq TvOg
	 */
	public WaveGenerator(long freq) {
		samplingFreqRate = freq;
	}
	/**
	 * w莞ԕ̃TvOf[^𐶐B
	 * @param sec Kvb(P:b)
	 * @return TvOf[^
	 */
	public synchronized byte[] getWaveData(double sec) {
		// 1t[̃oCg
		int needLength = (int)(samplingFreqRate * sec);
		
		// gݒ肳ĂȂꍇCf[^𐶐ȂŏI
		if(frequency < 0 || Double.isInfinite(frequency)) {
			return new byte[needLength];
		}
		
		if(f == null) {
			f = generateWaveData();
		}

		byte[] outdata = new byte[needLength];
		int i = 0;
		if(remain !=null) {
			for(; count_s < remain.length; i++) {
				outdata[i] = remain[count_s++];
			}
		}
		for(; i < outdata.length; i++) {
			outdata[i] = f[count];

			count++;
			if(count >= f.length) {
				count = 0;
			}
		}
		count_s = 0;
		remain = null;

		return outdata;
	}
	/**
	 * g`f[^̃LbVNAB
	 */
	protected void clearWaveCache() {
		offset = 0.0d;
		remain = f;
		count_s = count;
		count = 0;
		f = null;
	}
	/**
	 * TvOf[^𐶐B
	 * @return ꂽg`f[^(1)
	 */
	protected abstract byte[] generateWaveData();
	/**
	 * ʃtB^D
	 * @param data
	 * @return
	 */
	public byte[] filterAmplifer(byte[] data) {
		return null;
	}
	/**
	 * ݂̏o͎gԂB
	 * @return o͎g
	 */
	public double getFrequency() {
		return frequency;
	}
	/**
	 * o͎gݒ肷B
	 * ݂̏o͎gƈقȂlݒ肵ꍇCgύẌƂC
	 * g`f[^̏o͊JnJE^0ɃZbgB
	 * @param frequency o͎g
	 */
	public synchronized void setFrequency(double frequency) {
		if(this.frequency != frequency) {
			// ݂̎gƈႤgݒ肳ꂽꍇCʒuJE^0ɃZbg
			clearWaveCache();
		}
		this.frequency = frequency;
	}
	/**
	 * ݂̏o͉ʃxԂB
	 * @return o͉ʃx(0`255)
	 */
	public int getVolume() {
		return volume;
	}
	/**
	 * ݂̏o͉ʃxݒ肷B
	 * @param volume o͉ʃx(0`255)
	 */
	public void setVolume(int volume) {
		this.volume = volume;
		clearWaveCache();
	}
	/**
	 * ݂̃ItZbgԂB
	 * @return ItZbg
	 */
	public double getOffset() {
		return offset;
	}
}
