/*
 * Decompiled with CFR 0.152.
 */
package com.mchange.v2.naming;

import com.mchange.v2.log.MLevel;
import com.mchange.v2.log.MLog;
import com.mchange.v2.log.MLogger;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import javax.naming.spi.ObjectFactory;

public final class ReferenceableUtils {
    static final MLogger logger = MLog.getLogger(class$com$mchange$v2$naming$ReferenceableUtils == null ? (class$com$mchange$v2$naming$ReferenceableUtils = ReferenceableUtils.class$("com.mchange.v2.naming.ReferenceableUtils")) : class$com$mchange$v2$naming$ReferenceableUtils);
    static final String REFADDR_VERSION = "version";
    static final String REFADDR_CLASSNAME = "classname";
    static final String REFADDR_FACTORY = "factory";
    static final String REFADDR_FACTORY_CLASS_LOCATION = "factoryClassLocation";
    static final String REFADDR_SIZE = "size";
    static final int CURRENT_REF_VERSION = 1;
    static /* synthetic */ Class class$com$mchange$v2$naming$ReferenceableUtils;

    public static String literalNullToNull(String s) {
        if (s == null || "null".equals(s)) {
            return null;
        }
        return s;
    }

    public static Object referenceToObject(Reference ref, Name name, Context nameCtx, Hashtable env) throws NamingException {
        try {
            ClassLoader cl;
            String fClassName = ref.getFactoryClassName();
            String fClassLocation = ref.getFactoryClassLocation();
            if (fClassLocation == null) {
                cl = ClassLoader.getSystemClassLoader();
            } else {
                URL u = new URL(fClassLocation);
                cl = new URLClassLoader(new URL[]{u}, ClassLoader.getSystemClassLoader());
            }
            Class<?> fClass = Class.forName(fClassName, true, cl);
            ObjectFactory of = (ObjectFactory)fClass.newInstance();
            return of.getObjectInstance(ref, name, nameCtx, env);
        }
        catch (Exception e) {
            if (logger.isLoggable(MLevel.FINE)) {
                logger.log(MLevel.FINE, "Could not resolve Reference to Object!", e);
            }
            NamingException ne = new NamingException("Could not resolve Reference to Object!");
            ne.setRootCause(e);
            throw ne;
        }
    }

    public static void appendToReference(Reference appendTo, Reference orig) throws NamingException {
        int len = orig.size();
        appendTo.add(new StringRefAddr(REFADDR_VERSION, String.valueOf(1)));
        appendTo.add(new StringRefAddr(REFADDR_CLASSNAME, orig.getClassName()));
        appendTo.add(new StringRefAddr(REFADDR_FACTORY, orig.getFactoryClassName()));
        appendTo.add(new StringRefAddr(REFADDR_FACTORY_CLASS_LOCATION, orig.getFactoryClassLocation()));
        appendTo.add(new StringRefAddr(REFADDR_SIZE, String.valueOf(len)));
        for (int i = 0; i < len; ++i) {
            appendTo.add(orig.get(i));
        }
    }

    public static ExtractRec extractNestedReference(Reference extractFrom, int index) throws NamingException {
        try {
            int version = Integer.parseInt((String)extractFrom.get(index++).getContent());
            if (version == 1) {
                String className = (String)extractFrom.get(index++).getContent();
                String factoryClassName = (String)extractFrom.get(index++).getContent();
                String factoryClassLocation = (String)extractFrom.get(index++).getContent();
                Reference outRef = new Reference(className, factoryClassName, factoryClassLocation);
                int size = Integer.parseInt((String)extractFrom.get(index++).getContent());
                for (int i = 0; i < size; ++i) {
                    outRef.add(extractFrom.get(index++));
                }
                return new ExtractRec(outRef, index);
            }
            throw new NamingException("Bad version of nested reference!!!");
        }
        catch (NumberFormatException e) {
            if (logger.isLoggable(MLevel.FINE)) {
                logger.log(MLevel.FINE, "Version or size nested reference was not a number!!!", e);
            }
            throw new NamingException("Version or size nested reference was not a number!!!");
        }
    }

    private ReferenceableUtils() {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class ExtractRec {
        public Reference ref;
        public int index;

        private ExtractRec(Reference ref, int index) {
            this.ref = ref;
            this.index = index;
        }
    }
}

