/*
 * Decompiled with CFR 0.152.
 */
package com.tombrus.cleanImports.engine;

import com.tombrus.cleanImports.engine.ImportFormatter;
import com.tombrus.cleanImports.engine.ImportGenerator;
import com.tombrus.cleanImports.engine.SortOfLexer;
import com.tombrus.cleanImports.model.ImportSpecification;
import com.tombrus.cleanImports.parser.ImportInfoProvider;
import com.tombrus.util.DB;
import com.tombrus.util.FileAndCRC;
import com.tombrus.util.InternalProblem;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ImportReplacer {
    public boolean DEBUG = false;
    public boolean DEBUG_MORE = DB.MORE("ImportReplacer.DEBUG_MORE");
    public boolean NO_UPDATING = DB.MORE("ImportReplacer.NO_UPDATE");
    public static boolean REM_SLASHSLASH = !Boolean.getBoolean("ImportReplacer.noRemoveSlashSlash");
    private ImportInfoProvider infoProvider;
    private File srcFile;
    private ImportSpecification specification;
    private boolean removeSurroundingSlashSlashComments;
    private static Pattern lexPattern = Pattern.compile("([ e/#]*p[ e/#]+w[ e/#]*;)?([ e/#]*)(((i[ e/#]+w[ e/#]*;[ /#]*)[ e/#]*)*)");

    public ImportReplacer(ImportInfoProvider importInfoProvider, File file, ImportSpecification importSpecification) {
        this(importInfoProvider, file, importSpecification, REM_SLASHSLASH);
    }

    public ImportReplacer(ImportInfoProvider importInfoProvider, File file, ImportSpecification importSpecification, boolean bl) {
        this.DEBUG = DB.ONE(file);
        this.infoProvider = importInfoProvider;
        this.srcFile = file;
        this.specification = importSpecification;
        this.removeSurroundingSlashSlashComments = bl;
    }

    public boolean replaceImports() throws IOException {
        String string;
        String string2;
        if (this.infoProvider.isErrorFile(this.srcFile)) {
            throw new InternalProblem("Compile Errors Detected");
        }
        boolean bl = false;
        String string3 = FileAndCRC.readStringFromFile(this.srcFile);
        if (string3.equals(string2 = this.replaceImports(string3, string = ImportFormatter.getImportStatements(new ImportGenerator(this.srcFile, this.infoProvider), this.specification, ImportReplacer.determineEOLString(string3))))) {
            if (this.DEBUG) {
                System.err.println("uptodate: " + this.srcFile.getPath());
            }
        } else {
            if (this.DEBUG) {
                System.err.println("========================================================================================");
                System.err.println("Update needed for: " + this.srcFile.getPath());
                if (this.NO_UPDATING) {
                    System.err.println("(But no update performed)");
                }
                System.err.println("====== Old contents ==================================================================================");
                System.err.println(string3);
                System.err.println("====== New contents ==================================================================================");
                System.err.println(string2);
                System.err.println("========================================================================================");
                int n = 0;
                while (n < string3.length()) {
                    System.err.print(string3.charAt(n));
                    if (string3.charAt(n) != string2.charAt(n)) {
                        System.err.println("Diff at " + n);
                        System.err.println("     old=" + string3.charAt(n - 1) + " " + string3.charAt(n) + " " + string3.charAt(n + 1));
                        System.err.println("     new=" + string2.charAt(n - 1) + " " + string2.charAt(n) + " " + string2.charAt(n + 1));
                        break;
                    }
                    ++n;
                }
                System.err.println("========================================================================================");
            }
            if (!this.NO_UPDATING) {
                if (this.DEBUG) {
                    System.err.println("updating: " + this.srcFile.getPath());
                }
                try {
                    FileAndCRC.writeStringToFile(string2, this.srcFile);
                    bl = true;
                }
                catch (FileNotFoundException fileNotFoundException) {
                    throw new InternalProblem("The file " + this.srcFile + " can not be updated because it is write protected.");
                }
            }
        }
        return bl;
    }

    private String replaceImports(String string, String string2) {
        String[] stringArray = this.breakImports(string, this.removeSurroundingSlashSlashComments);
        String[] stringArray2 = this.breakImports(string2, false);
        if (this.DEBUG && this.DEBUG_MORE) {
            int n = 0;
            while (n < 5) {
                System.err.println("============================= old " + n + ":");
                System.err.println("--" + stringArray[n] + "--");
                System.err.println("============================= new " + n + ":");
                System.err.println("--" + stringArray2[n] + "--");
                ++n;
            }
        }
        String string3 = stringArray[1].endsWith(stringArray2[1]) ? "" : stringArray2[1];
        String string4 = stringArray[3].startsWith(stringArray2[3]) ? "" : stringArray2[3];
        String string5 = stringArray[0] + stringArray[1] + string3 + stringArray2[2] + string4 + stringArray[3] + stringArray[4];
        return string5;
    }

    private String[] breakImports(String string, boolean bl) {
        SortOfLexer sortOfLexer = new SortOfLexer(string);
        int n = -1;
        int n2 = -1;
        int n3 = -1;
        int n4 = -1;
        Matcher matcher = lexPattern.matcher(sortOfLexer.toTypeString());
        if (matcher.find()) {
            n = matcher.start(2);
            n2 = matcher.start(3);
            n3 = matcher.end(5);
            n4 = matcher.end(3);
            if (n3 == -1) {
                n3 = n2;
            }
        }
        if (this.DEBUG && this.DEBUG_MORE) {
            System.err.println("type sequence = " + sortOfLexer.toTypeString());
            System.err.println("     afterPackage    = " + n);
            System.err.println("     firstImport     = " + n2);
            System.err.println("     afterLastImport = " + n3);
            System.err.println("     bodyStart       = " + n4);
        }
        if (n == -1 || n2 == -1 || n3 == -1 || n4 == -1) {
            System.err.println("=================== problem....");
            System.err.println(string);
            System.err.println("===============================");
            System.err.println(sortOfLexer.toTypeString());
            System.err.println("===============================");
            throw new InternalProblem("consistency error in lex matcher: " + n + "/" + n2 + "/" + n3 + "/" + n4);
        }
        if (bl) {
            this.removeCommentsAndCollapseEOLs(sortOfLexer, n, n2, 2);
            this.removeCommentsAndCollapseEOLs(sortOfLexer, n3, n4, 1);
        }
        if (this.DEBUG && this.DEBUG_MORE) {
            System.err.println("==============================");
            int n5 = 0;
            while (n5 < sortOfLexer.size()) {
                System.err.println(" - " + n5 + " " + sortOfLexer.getType(n5) + ": '" + sortOfLexer.getValue(n5).replace('\r', '@').replace('\n', '#').replace('\t', '>').replace(' ', '.') + "'");
                ++n5;
            }
            System.err.println("==============================");
        }
        return new String[]{sortOfLexer.toString(0, n), sortOfLexer.toString(n, n2), sortOfLexer.toString(n2, n3), sortOfLexer.toString(n3, n4), sortOfLexer.toString(n4, sortOfLexer.size())};
    }

    private void removeCommentsAndCollapseEOLs(SortOfLexer sortOfLexer, int n, int n2, int n3) {
        int n4 = 0;
        int n5 = n;
        while (n5 < n2) {
            if (sortOfLexer.getType(n5) == '/') {
                sortOfLexer.remove(n5);
            } else if (sortOfLexer.getType(n5) == 'e') {
                if (n4 >= n3) {
                    sortOfLexer.remove(n5);
                }
                ++n4;
            } else {
                n4 = sortOfLexer.getValue(n5).endsWith("\n") || sortOfLexer.getValue(n5).endsWith("\r") ? 1 : 0;
            }
            ++n5;
        }
    }

    private static String determineEOLString(String string) {
        int n = string.indexOf(10);
        int n2 = string.indexOf(13);
        if (n == -1 && n2 != -1) {
            return "\r";
        }
        if (n != -1 && n2 == -1) {
            return "\n";
        }
        if (n != -1 && n2 != -1) {
            int n3;
            int n4 = Math.min(n, n2);
            if (n4 + 1 == (n3 = Math.max(n, n2))) {
                return string.substring(n4, n4 + 2);
            }
            return "\n";
        }
        return "\n";
    }
}

