/*
 * Decompiled with CFR 0.152.
 */
package net.sf.swarmcache;

import java.io.Serializable;
import java.util.Collections;
import java.util.Map;
import net.sf.swarmcache.LRUCacheListener;
import net.sf.swarmcache.ObjectCache;
import org.apache.commons.collections.LRUMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LRUCache
implements ObjectCache {
    Log log = LogFactory.getLog(this.getClass());
    public static final String LRU_CACHE_SIZE_PROPERTY = "lru.cache.size";
    public static final int DEFAULT_CACHE_SIZE = 1000;
    private String type;
    private int size = 1000;
    private Map cache;
    private ListeningLRUMap map;

    public LRUCache() {
        String property = System.getProperty(LRU_CACHE_SIZE_PROPERTY);
        if (property != null) {
            try {
                this.size = Integer.parseInt(property);
            }
            catch (NumberFormatException nfe) {
                this.log.warn((Object)"LRU cache size was improperly specified.");
                nfe.printStackTrace();
            }
        }
        this.map = new ListeningLRUMap(this.size);
        this.cache = Collections.synchronizedMap(this.map);
    }

    public void setSize(int newSize) {
        this.size = newSize;
        this.map.setMaximumSize(newSize);
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.log.debug((Object)("Cache type set to '" + type + "'."));
        this.type = type;
    }

    public void put(Serializable key, Object object) {
        this.cache.put(key, object);
        this.log.debug((Object)("Put " + this.type + " #" + key + " in to cache."));
    }

    public Object get(Serializable key) {
        Object object = this.cache.get(key);
        if (object != null) {
            this.log.debug((Object)("Got " + this.type + " #" + key + " from cache."));
        }
        return object;
    }

    public Object clear(Serializable key) {
        this.log.debug((Object)("Cleared " + this.type + " #" + key + " from cache."));
        return this.cache.remove(key);
    }

    public void clearAll() {
        this.log.debug((Object)("Cleared entire " + this.type + " cache."));
        this.cache = Collections.synchronizedMap(new LRUMap(this.size));
    }

    public void setListener(LRUCacheListener l) {
        this.map.setListener(l);
    }

    public class ListeningLRUMap
    extends LRUMap {
        private LRUCacheListener listener = null;

        public ListeningLRUMap(int size) {
            super(size);
        }

        public void setListener(LRUCacheListener l) {
            this.listener = l;
        }

        protected void processRemovedLRU(Object key, Object value) {
            if (this.listener != null) {
                this.listener.objectRemoved((Serializable)key, value);
            }
        }
    }
}

