/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.jdbc2;

import java.io.InputStream;
import java.sql.Blob;
import java.sql.SQLException;
import org.postgresql.PGConnection;
import org.postgresql.largeobject.LargeObject;
import org.postgresql.largeobject.LargeObjectManager;
import org.postgresql.util.GT;
import org.postgresql.util.PSQLException;
import org.postgresql.util.PSQLState;

public class AbstractJdbc2BlobClob {
    private LargeObject lo;

    public AbstractJdbc2BlobClob(PGConnection conn, int oid) throws SQLException {
        LargeObjectManager lom = conn.getLargeObjectAPI();
        this.lo = lom.open(oid);
    }

    public long length() throws SQLException {
        return this.lo.size();
    }

    public byte[] getBytes(long pos, int length) throws SQLException {
        this.assertPosition(pos);
        this.lo.seek((int)(pos - 1L), 0);
        return this.lo.read(length);
    }

    public InputStream getBinaryStream() throws SQLException {
        return this.lo.getInputStream();
    }

    public long position(byte[] pattern, long start) throws SQLException {
        this.assertPosition(start, pattern.length);
        int position = 1;
        int patternIdx = 0;
        long result = -1L;
        int tmpPosition = 1;
        LOIterator i = new LOIterator(start - 1L);
        while (i.hasNext()) {
            byte b = i.next();
            if (b == pattern[patternIdx]) {
                if (patternIdx == 0) {
                    tmpPosition = position;
                }
                if (++patternIdx == pattern.length) {
                    result = tmpPosition;
                    break;
                }
            } else {
                patternIdx = 0;
            }
            ++position;
        }
        return result;
    }

    public long position(Blob pattern, long start) throws SQLException {
        return this.position(pattern.getBytes(1L, (int)pattern.length()), start);
    }

    protected LargeObject getLO() {
        return this.lo;
    }

    protected void assertPosition(long pos) throws SQLException {
        this.assertPosition(pos, 0L);
    }

    protected void assertPosition(long pos, long len) throws SQLException {
        if (pos < 1L) {
            throw new PSQLException(GT.tr("LOB positioning offsets start at 1."), PSQLState.INVALID_PARAMETER_VALUE);
        }
        if (pos + len - 1L > Integer.MAX_VALUE) {
            throw new PSQLException(GT.tr("PostgreSQL LOBs can only index to: {0}", new Integer(Integer.MAX_VALUE)), PSQLState.INVALID_PARAMETER_VALUE);
        }
    }

    private class LOIterator {
        private static final int BUFFER_SIZE = 8096;
        private byte[] buffer = new byte[8096];
        private int idx = 8096;
        private int numBytes = 8096;

        public LOIterator(long start) throws SQLException {
            AbstractJdbc2BlobClob.this.lo.seek((int)start);
        }

        public boolean hasNext() throws SQLException {
            boolean result = false;
            if (this.idx < this.numBytes) {
                result = true;
            } else {
                this.numBytes = AbstractJdbc2BlobClob.this.lo.read(this.buffer, 0, 8096);
                this.idx = 0;
                result = this.numBytes > 0;
            }
            return result;
        }

        private byte next() {
            return this.buffer[this.idx++];
        }
    }
}

