/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks;

import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.TextBlock;
import com.puppycrawl.tools.checkstyle.checks.AbstractFormatCheck;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.beanutils.ConversionException;
import org.apache.regexp.RE;

public class TrailingCommentCheck
extends AbstractFormatCheck {
    private static final String DEFAULT_FORMAT = "^[\\s\\}\\);]*$";

    public TrailingCommentCheck() throws ConversionException {
        super(DEFAULT_FORMAT);
    }

    public int[] getDefaultTokens() {
        return new int[0];
    }

    public void visitToken(DetailAST aAST) {
        throw new IllegalStateException("visitToken() shouldn't be called.");
    }

    public void beginTree(DetailAST aRootAST) {
        RE blankLinePattern = this.getRegexp();
        Map cppComments = this.getFileContents().getCppComments();
        Map cComments = this.getFileContents().getCComments();
        HashSet lines = new HashSet();
        lines.addAll(cppComments.keySet());
        lines.addAll(cComments.keySet());
        Iterator linesIter = lines.iterator();
        while (linesIter.hasNext()) {
            Integer lineNo = (Integer)linesIter.next();
            String line = this.getLines()[lineNo - 1];
            String lineBefore = "";
            if (cppComments.containsKey(lineNo)) {
                TextBlock comment = (TextBlock)cppComments.get(lineNo);
                lineBefore = line.substring(0, comment.getStartColNo());
            } else if (cComments.containsKey(lineNo)) {
                String lineAfter;
                List commentList = (List)cComments.get(lineNo);
                TextBlock comment = (TextBlock)commentList.get(commentList.size() - 1);
                lineBefore = line.substring(0, comment.getStartColNo());
                if (comment.getText().length == 1 && !"".equals(lineAfter = line.substring(comment.getEndColNo() + 1).trim())) continue;
            }
            if (blankLinePattern.match(lineBefore)) continue;
            this.log(lineNo, "trailing.comments");
        }
    }
}

