/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.coding;

import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.FullIdent;
import com.puppycrawl.tools.checkstyle.checks.AbstractFormatCheck;
import com.puppycrawl.tools.checkstyle.checks.CheckUtils;
import java.util.HashSet;
import java.util.Set;

public final class IllegalTypeCheck
extends AbstractFormatCheck {
    private static final String DEFAULT_FORMAT = "^(.*[\\.])?Abstract.*$";
    private static final String[] DEFAULT_ILLEGAL_TYPES = new String[]{"GregorianCalendar", "Hashtable", "HashSet", "HashMap", "ArrayList", "LinkedList", "LinkedHashMap", "LinkedHashSet", "TreeSet", "TreeMap", "Vector", "java.util.GregorianCalendar", "java.util.Hashtable", "java.util.HashSet", "java.util.HashMap", "java.util.ArrayList", "java.util.LinkedList", "java.util.LinkedHashMap", "java.util.LinkedHashSet", "java.util.TreeSet", "java.util.TreeMap", "java.util.Vector"};
    private final Set mIllegalClassNames = new HashSet();
    private final Set mIgnoredMethodNames = new HashSet();

    public IllegalTypeCheck() {
        super(DEFAULT_FORMAT);
        this.setIllegalClassNames(DEFAULT_ILLEGAL_TYPES);
        this.setIgnoredMethodNames(new String[]{"getInitialContext", "getEnvironment"});
    }

    public int[] getDefaultTokens() {
        return new int[]{10, 21, 9};
    }

    public void visitToken(DetailAST aAST) {
        switch (aAST.getType()) {
            case 9: {
                this.visitMethodDef(aAST);
                break;
            }
            case 10: {
                this.visitVariableDef(aAST);
                break;
            }
            case 21: {
                this.visitParameterDef(aAST);
                break;
            }
            default: {
                throw new IllegalStateException(aAST.toString());
            }
        }
    }

    private void visitMethodDef(DetailAST aAST) {
        if (this.isCheckedMethod(aAST)) {
            this.checkClassName(aAST);
        }
    }

    private void visitParameterDef(DetailAST aAST) {
        DetailAST grandParentAST = aAST.getParent().getParent();
        if (grandParentAST.getType() == 9 && this.isCheckedMethod(grandParentAST)) {
            this.checkClassName(aAST);
        }
    }

    private void visitVariableDef(DetailAST aAST) {
        this.checkClassName(aAST);
    }

    private void checkClassName(DetailAST aAST) {
        DetailAST type = aAST.findFirstToken(13);
        FullIdent ident = CheckUtils.createFullType(type);
        if (this.isMatchingClassName(ident.getText())) {
            this.log(ident.getLineNo(), ident.getColumnNo(), "illegal.type", (Object)ident.getText());
        }
    }

    private boolean isMatchingClassName(String aClassName) {
        return this.mIllegalClassNames.contains(aClassName) || this.getRegexp().match(aClassName);
    }

    private boolean isCheckedMethod(DetailAST aAST) {
        String methodName = aAST.findFirstToken(58).getText();
        return !this.mIgnoredMethodNames.contains(methodName);
    }

    public void setIllegalClassNames(String[] aClassNames) {
        this.mIllegalClassNames.clear();
        for (int i = 0; i < aClassNames.length; ++i) {
            String name = aClassNames[i];
            this.mIllegalClassNames.add(name);
            int lastDot = name.lastIndexOf(".");
            if (lastDot <= 0 || lastDot >= name.length() - 1) continue;
            String shortName = name.substring(name.lastIndexOf(".") + 1);
            this.mIllegalClassNames.add(shortName);
        }
    }

    public String[] getIllegalClassNames() {
        return this.mIllegalClassNames.toArray(new String[0]);
    }

    public void setIgnoredMethodNames(String[] aMethodNames) {
        this.mIgnoredMethodNames.clear();
        for (int i = 0; i < aMethodNames.length; ++i) {
            this.mIgnoredMethodNames.add(aMethodNames[i]);
        }
    }

    public String[] getIgnoredMethodNames() {
        return this.mIgnoredMethodNames.toArray(new String[0]);
    }
}

