/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.service.lease;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.jgroups.Header;

public class LeaseResponseHeader
extends Header {
    public static final String HEADER_KEY = "leaseResponseHeader";
    public static final int NONE = 0;
    public static final int LEASE_GRANTED = 1;
    public static final int LEASE_RENEWED = 2;
    public static final int LEASE_CANCELED = 3;
    private int headerType;
    private long duration;
    private boolean isAbsolute;
    private Object tenant;

    public LeaseResponseHeader() {
        this.headerType = 0;
        this.duration = -1L;
        this.isAbsolute = false;
    }

    public LeaseResponseHeader(int headerType, Object tenant) {
        boolean correctHeaderType;
        boolean bl = correctHeaderType = headerType == 3;
        if (!correctHeaderType) {
            throw new IllegalArgumentException("Only LEASE_CANCELED type is allowed in this constructor.");
        }
        this.headerType = headerType;
        this.tenant = tenant;
    }

    public LeaseResponseHeader(int headerType, long duration, boolean isAbsolute, Object tenant) {
        boolean correctHeaderType;
        boolean bl = correctHeaderType = headerType == 1 || headerType == 2;
        if (!correctHeaderType) {
            throw new IllegalArgumentException("Only LEASE_GRANTED or LEASE_RENEWED types are allowed in this constructor.");
        }
        this.headerType = headerType;
        this.duration = duration;
        this.isAbsolute = isAbsolute;
        this.tenant = tenant;
    }

    public int getType() {
        return this.headerType;
    }

    public long getDuration() {
        return this.duration;
    }

    public boolean isAbsolute() {
        return this.isAbsolute;
    }

    public Object getTenant() {
        return this.tenant;
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.headerType = in.readInt();
        this.duration = in.readLong();
        this.isAbsolute = in.readBoolean();
        this.tenant = in.readObject();
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.headerType);
        out.writeLong(this.duration);
        out.writeBoolean(this.isAbsolute);
        out.writeObject(this.tenant);
    }
}

