/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.deployment;

import java.util.ArrayList;
import java.util.StringTokenizer;
import org.jboss.deployment.DeploymentSorter;

public class SuffixOrderHelper {
    public static final String[] DEFAULT_ENHANCED_SUFFIX_ORDER = new String[]{"100:deployer", "100:deployer.xml", "200:sar", "200:service.xml", "300:rar", "300:ds.xml", "500:jar", "600:war", "600:wsr", "600:ear", "700:zip", "900:last"};
    private final DeploymentSorter sorter;
    private String[] enhancedSuffixOrder;
    private ArrayList suffixes;

    public SuffixOrderHelper(DeploymentSorter sorter) {
        this.sorter = sorter;
        this.suffixes = new ArrayList();
    }

    public String[] getSuffixOrder() {
        return this.sorter.getSuffixOrder();
    }

    public String[] getEnhancedSuffixOrder() {
        return this.enhancedSuffixOrder;
    }

    public void setEnhancedSuffixOrder(String[] enhancedSuffixOrder) {
        this.enhancedSuffixOrder = enhancedSuffixOrder;
    }

    public void init() {
        if (this.enhancedSuffixOrder == null) {
            this.enhancedSuffixOrder = DEFAULT_ENHANCED_SUFFIX_ORDER;
        }
        for (int i = 0; i < this.enhancedSuffixOrder.length; ++i) {
            this.addSuffix(new SuffixEntry(this.enhancedSuffixOrder[i], true));
        }
        this.sorter.setSuffixOrder(this.produceSuffixOrder());
    }

    public void addSuffixes(String[] suffixes, int order) {
        if (suffixes != null) {
            int size = this.suffixes.size();
            for (int i = 0; i < suffixes.length; ++i) {
                try {
                    this.addSuffix(new SuffixEntry(suffixes[i], order, false));
                    continue;
                }
                catch (RuntimeException e) {
                    // empty catch block
                }
            }
            if (this.suffixes.size() > size) {
                this.sorter.setSuffixOrder(this.produceSuffixOrder());
            }
        }
    }

    public void removeSuffixes(String[] suffixes, int order) {
        if (suffixes != null) {
            int size = this.suffixes.size();
            for (int i = 0; i < suffixes.length; ++i) {
                int pos = this.suffixes.indexOf(new SuffixEntry(suffixes[i], order, false));
                if (pos < 0) continue;
                SuffixEntry entry = (SuffixEntry)this.suffixes.get(pos);
                if (entry.fixed) continue;
                this.suffixes.remove(pos);
            }
            if (this.suffixes.size() < size) {
                this.sorter.setSuffixOrder(this.produceSuffixOrder());
            }
        }
    }

    private String[] produceSuffixOrder() {
        String[] suffixOrder = new String[this.suffixes.size()];
        for (int i = 0; i < this.suffixes.size(); ++i) {
            suffixOrder[i] = ((SuffixEntry)this.suffixes.get((int)i)).suffix;
        }
        return suffixOrder;
    }

    private void addSuffix(SuffixEntry suffix) {
        if (this.suffixes.indexOf(suffix) >= 0) {
            throw new RuntimeException("suffix exists: " + suffix);
        }
        int size = this.suffixes.size();
        if (size == 0) {
            this.suffixes.add(suffix);
        } else {
            for (int i = size - 1; i > -1; --i) {
                SuffixEntry entry = (SuffixEntry)this.suffixes.get(i);
                if (suffix.order >= entry.order) {
                    this.suffixes.add(i + 1, suffix);
                    break;
                }
                if (i != 0) continue;
                this.suffixes.add(0, suffix);
            }
        }
    }

    private static class SuffixEntry {
        public String suffix;
        public int order;
        public boolean fixed;

        public SuffixEntry(String suffix, int order, boolean fixed) {
            this.suffix = suffix;
            this.order = order;
            this.fixed = fixed;
        }

        public SuffixEntry(String enhancedSuffix, boolean fixed) {
            StringTokenizer tokenizer = new StringTokenizer(enhancedSuffix, ":");
            int tokens = tokenizer.countTokens();
            switch (tokens) {
                case 1: {
                    this.order = 500;
                    this.suffix = enhancedSuffix;
                    break;
                }
                case 2: {
                    this.order = Integer.parseInt(tokenizer.nextToken());
                    this.suffix = tokenizer.nextToken();
                    break;
                }
                default: {
                    throw new RuntimeException("cannot parse enhancedSuffix: " + enhancedSuffix);
                }
            }
            this.fixed = fixed;
        }

        public boolean equals(Object other) {
            if (other == null) {
                return false;
            }
            if (this == other) {
                return true;
            }
            if (!(other instanceof SuffixEntry)) {
                return false;
            }
            SuffixEntry that = (SuffixEntry)other;
            return this.suffix.equals(that.suffix);
        }

        public int hashCode() {
            return this.suffix.hashCode();
        }

        public String toString() {
            return this.order + 58 + this.suffix;
        }
    }
}

