/*
 * Decompiled with CFR 0.152.
 */
package twitter4j.http;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Random;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import twitter4j.Configuration;
import twitter4j.http.BASE64Encoder;
import twitter4j.http.OAuthToken;
import twitter4j.http.PostParameter;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OAuth {
    private static final String HMAC_SHA1 = "HmacSHA1";
    private static final PostParameter OAUTH_SIGNATURE_METHOD = new PostParameter("oauth_signature_method", "HMAC-SHA1");
    private static final boolean DEBUG = Configuration.getDebug();
    private String consumerKey = "";
    private String consumerSecret;
    private static Random RAND = new Random();

    public OAuth(String consumerKey, String consumerSecret) {
        this.setConsumerKey(consumerKey);
        this.setConsumerSecret(consumerSecret);
    }

    String generateAuthorizationHeader(String method, String url, PostParameter[] params, String nonce, String timestamp, OAuthToken otoken) {
        if (null == params) {
            params = new PostParameter[]{};
        }
        ArrayList<PostParameter> oauthHeaderParams = new ArrayList<PostParameter>(5);
        oauthHeaderParams.add(new PostParameter("oauth_consumer_key", this.consumerKey));
        oauthHeaderParams.add(OAUTH_SIGNATURE_METHOD);
        oauthHeaderParams.add(new PostParameter("oauth_timestamp", timestamp));
        oauthHeaderParams.add(new PostParameter("oauth_nonce", nonce));
        oauthHeaderParams.add(new PostParameter("oauth_version", "1.0"));
        if (null != otoken) {
            oauthHeaderParams.add(new PostParameter("oauth_token", otoken.getToken()));
        }
        ArrayList<PostParameter> signatureBaseParams = new ArrayList<PostParameter>(oauthHeaderParams.size() + params.length);
        signatureBaseParams.addAll(oauthHeaderParams);
        signatureBaseParams.addAll(OAuth.toParamList(params));
        this.parseGetParameters(url, signatureBaseParams);
        StringBuffer base = new StringBuffer(method).append("&").append(OAuth.encode(OAuth.constructRequestURL(url))).append("&");
        base.append(OAuth.encode(OAuth.normalizeRequestParameters(signatureBaseParams)));
        String oauthBaseString = base.toString();
        this.log("OAuth base string:", oauthBaseString);
        String signature = this.generateSignature(oauthBaseString, otoken);
        this.log("OAuth signature:", signature);
        oauthHeaderParams.add(new PostParameter("oauth_signature", signature));
        return new StringBuffer().append("OAuth ").append(OAuth.encodeParameters(oauthHeaderParams, ",", true)).toString();
    }

    private void parseGetParameters(String url, List<PostParameter> signatureBaseParams) {
        int queryStart = url.indexOf("?");
        if (-1 != queryStart) {
            String[] queryStrs = url.substring(queryStart + 1).split("&");
            try {
                for (String query : queryStrs) {
                    String[] split = query.split("=");
                    if (split.length == 2) {
                        signatureBaseParams.add(new PostParameter(URLDecoder.decode(split[0], "UTF-8"), URLDecoder.decode(split[1], "UTF-8")));
                        continue;
                    }
                    signatureBaseParams.add(new PostParameter(URLDecoder.decode(split[0], "UTF-8"), ""));
                }
            }
            catch (UnsupportedEncodingException ignore) {
                // empty catch block
            }
        }
    }

    String generateAuthorizationHeader(String method, String url, PostParameter[] params, OAuthToken token) {
        long timestamp = System.currentTimeMillis() / 1000L;
        long nonce = timestamp + (long)RAND.nextInt();
        return this.generateAuthorizationHeader(method, url, params, String.valueOf(nonce), String.valueOf(timestamp), token);
    }

    String generateSignature(String data, OAuthToken token) {
        byte[] byteHMAC = null;
        try {
            SecretKeySpec spec;
            Mac mac = Mac.getInstance(HMAC_SHA1);
            if (null == token) {
                String oauthSignature = new StringBuffer().append(OAuth.encode(this.consumerSecret)).append("&").toString();
                spec = new SecretKeySpec(oauthSignature.getBytes(), HMAC_SHA1);
            } else {
                if (null == token.getSecretKeySpec()) {
                    String oauthSignature = new StringBuffer().append(OAuth.encode(this.consumerSecret)).append("&").append(OAuth.encode(token.getTokenSecret())).toString();
                    spec = new SecretKeySpec(oauthSignature.getBytes(), HMAC_SHA1);
                    token.setSecretKeySpec(spec);
                }
                spec = token.getSecretKeySpec();
            }
            mac.init(spec);
            byteHMAC = mac.doFinal(data.getBytes());
        }
        catch (InvalidKeyException e) {
            e.printStackTrace();
        }
        catch (NoSuchAlgorithmException ignore) {
            // empty catch block
        }
        return new BASE64Encoder().encode(byteHMAC);
    }

    String generateSignature(String data) {
        return this.generateSignature(data, null);
    }

    public static String normalizeRequestParameters(PostParameter[] params) {
        return OAuth.normalizeRequestParameters(OAuth.toParamList(params));
    }

    public static String normalizeRequestParameters(List<PostParameter> params) {
        Collections.sort(params);
        return OAuth.encodeParameters(params);
    }

    public static String normalizeAuthorizationHeaders(List<PostParameter> params) {
        Collections.sort(params);
        return OAuth.encodeParameters(params);
    }

    public static List<PostParameter> toParamList(PostParameter[] params) {
        ArrayList<PostParameter> paramList = new ArrayList<PostParameter>(params.length);
        paramList.addAll(Arrays.asList(params));
        return paramList;
    }

    public static String encodeParameters(List<PostParameter> postParams) {
        return OAuth.encodeParameters(postParams, "&", false);
    }

    public static String encodeParameters(List<PostParameter> postParams, String splitter, boolean quot) {
        StringBuffer buf = new StringBuffer();
        for (PostParameter param : postParams) {
            if (buf.length() != 0) {
                if (quot) {
                    buf.append("\"");
                }
                buf.append(splitter);
            }
            buf.append(OAuth.encode(param.name)).append("=");
            if (quot) {
                buf.append("\"");
            }
            buf.append(OAuth.encode(param.value));
        }
        if (buf.length() != 0 && quot) {
            buf.append("\"");
        }
        return buf.toString();
    }

    public static String encode(String value) {
        String encoded = null;
        try {
            encoded = URLEncoder.encode(value, "UTF-8");
        }
        catch (UnsupportedEncodingException ignore) {
            // empty catch block
        }
        StringBuffer buf = new StringBuffer(encoded.length());
        for (int i = 0; i < encoded.length(); ++i) {
            char focus = encoded.charAt(i);
            if (focus == '*') {
                buf.append("%2A");
                continue;
            }
            if (focus == '+') {
                buf.append("%20");
                continue;
            }
            if (focus == '%' && i + 1 < encoded.length() && encoded.charAt(i + 1) == '7' && encoded.charAt(i + 2) == 'E') {
                buf.append('~');
                i += 2;
                continue;
            }
            buf.append(focus);
        }
        return buf.toString();
    }

    public static String constructRequestURL(String url) {
        int slashIndex;
        String baseURL;
        int colonIndex;
        int index = url.indexOf("?");
        if (-1 != index) {
            url = url.substring(0, index);
        }
        if (-1 != (colonIndex = (baseURL = url.substring(0, slashIndex = url.indexOf("/", 8)).toLowerCase()).indexOf(":", 8))) {
            if (baseURL.startsWith("http://") && baseURL.endsWith(":80")) {
                baseURL = baseURL.substring(0, colonIndex);
            } else if (baseURL.startsWith("https://") && baseURL.endsWith(":443")) {
                baseURL = baseURL.substring(0, colonIndex);
            }
        }
        url = new StringBuffer().append(baseURL).append(url.substring(slashIndex)).toString();
        return url;
    }

    public void setConsumerKey(String consumerKey) {
        this.consumerKey = null != consumerKey ? consumerKey : "";
    }

    public void setConsumerSecret(String consumerSecret) {
        this.consumerSecret = null != consumerSecret ? consumerSecret : "";
    }

    private void log(String message) {
        if (DEBUG) {
            System.out.println(new StringBuffer().append("[").append(new Date()).append("]").append(message).toString());
        }
    }

    private void log(String message, String message2) {
        if (DEBUG) {
            this.log(new StringBuffer().append(message).append(message2).toString());
        }
    }
}

