/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.eviction;

import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.jboss.cache.Fqn;
import org.jboss.cache.eviction.LFUComparator;
import org.jboss.cache.eviction.NodeEntry;
import org.jboss.cache.eviction.SortedEvictionQueue;

public class LFUQueue
implements SortedEvictionQueue {
    private Map nodeMap = new HashMap();
    private LinkedList evictionList;
    private Comparator comparator = new LFUComparator();
    private Set removalQueue;

    LFUQueue() {
        this.evictionList = new LinkedList();
        this.removalQueue = new HashSet();
    }

    public NodeEntry getFirstNodeEntry() {
        try {
            NodeEntry ne;
            while ((ne = (NodeEntry)this.evictionList.getFirst()) != null && this.removalQueue.contains(ne)) {
                this.evictionList.removeFirst();
                this.removalQueue.remove(ne);
            }
            return ne;
        }
        catch (NoSuchElementException noSuchElementException) {
            return null;
        }
    }

    public NodeEntry getNodeEntry(Fqn fqn) {
        return this.getNodeEntry(fqn.toString());
    }

    public NodeEntry getNodeEntry(String fqn) {
        return (NodeEntry)this.nodeMap.get(fqn);
    }

    public boolean containsNodeEntry(NodeEntry entry) {
        Fqn fqn = entry.getFqn();
        return this.getNodeEntry(fqn) != null;
    }

    public void removeNodeEntry(NodeEntry entry) {
        NodeEntry ne = (NodeEntry)this.nodeMap.remove(entry.getFqn().toString());
        if (ne != null) {
            this.removalQueue.add(ne);
        }
    }

    public void addNodeEntry(NodeEntry entry) {
        if (!this.containsNodeEntry(entry)) {
            Fqn fqn = entry.getFqn();
            this.nodeMap.put(fqn.toString(), entry);
            this.evictionList.add(entry);
        }
    }

    public int size() {
        return this.nodeMap.size();
    }

    public void clear() {
        this.nodeMap.clear();
        this.evictionList.clear();
        this.removalQueue.clear();
    }

    public void resortEvictionQueue() {
        Collections.sort(this.evictionList, this.comparator);
    }

    void prune() {
        Iterator it = this.iterate();
        while (it.hasNext() && this.removalQueue.size() > 0) {
            if (!this.removalQueue.remove(it.next())) continue;
            it.remove();
        }
    }

    final List getEvictionList() {
        return this.evictionList;
    }

    final Set getRemovalQueue() {
        return this.removalQueue;
    }

    final Iterator iterate() {
        return this.evictionList.iterator();
    }
}

