/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.eviction;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jboss.cache.Fqn;
import org.jboss.cache.eviction.EvictionQueue;
import org.jboss.cache.eviction.NodeEntry;

public class LRUQueue
implements EvictionQueue {
    private Map maxAgeQueue = new LinkedHashMap();
    private Map lruQueue = new LinkedHashMap(16, 0.75f, true);
    private long alternatingCount = 0L;

    LRUQueue() {
    }

    void reorderByLRU(Fqn fqn) {
        this.lruQueue.get(fqn.toString());
    }

    public NodeEntry getFirstNodeEntry() {
        NodeEntry ne;
        if (this.alternatingCount % 2L == 0L) {
            ne = this.getFirstLRUNodeEntry();
            if (ne == null) {
                ne = this.getFirstMaxAgeNodeEntry();
            }
        } else {
            ne = this.getFirstMaxAgeNodeEntry();
            if (ne == null) {
                ne = this.getFirstLRUNodeEntry();
            }
        }
        ++this.alternatingCount;
        return ne;
    }

    public NodeEntry getFirstLRUNodeEntry() {
        if (this.lruQueue.size() > 0) {
            return (NodeEntry)this.lruQueue.values().iterator().next();
        }
        return null;
    }

    public NodeEntry getFirstMaxAgeNodeEntry() {
        if (this.maxAgeQueue.size() > 0) {
            return (NodeEntry)this.maxAgeQueue.values().iterator().next();
        }
        return null;
    }

    public NodeEntry getNodeEntry(Fqn fqn) {
        return this.getNodeEntry(fqn.toString());
    }

    public NodeEntry getNodeEntry(String fqn) {
        return (NodeEntry)this.lruQueue.get(fqn);
    }

    public boolean containsNodeEntry(NodeEntry entry) {
        return this.maxAgeQueue.containsKey(entry.getFqn().toString());
    }

    public void removeNodeEntry(NodeEntry entry) {
        if (!this.containsNodeEntry(entry)) {
            return;
        }
        String fqn = entry.getFqn().toString();
        if (this.lruQueue.remove(fqn) == null || this.maxAgeQueue.remove(fqn) == null) {
            throw new RuntimeException("The queues are out of sync.");
        }
    }

    public void addNodeEntry(NodeEntry entry) {
        if (!this.containsNodeEntry(entry)) {
            String fqn = entry.getFqn().toString();
            this.maxAgeQueue.put(fqn, entry);
            this.lruQueue.put(fqn, entry);
        }
    }

    public int size() {
        return this.maxAgeQueue.size();
    }

    public void clear() {
        this.maxAgeQueue.clear();
        this.lruQueue.clear();
    }

    final Iterator iterateMaxAgeQueue() {
        return this.maxAgeQueue.values().iterator();
    }

    final Iterator iterateLRUQueue() {
        return this.lruQueue.values().iterator();
    }
}

