/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.eviction;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.cache.CacheException;
import org.jboss.cache.ConfigureException;
import org.jboss.cache.Fqn;
import org.jboss.cache.TreeCache;
import org.jboss.cache.TreeCacheListener;
import org.jboss.cache.aop.AOPInstance;
import org.jboss.cache.aop.TreeCacheAop;
import org.jboss.cache.eviction.EvictionConfiguration;
import org.jboss.cache.eviction.EvictionPolicy;
import org.jboss.cache.eviction.EvictionTimerTask;
import org.jboss.cache.eviction.Region;
import org.jboss.cache.eviction.RegionNameConflictException;
import org.jboss.cache.xml.XmlHelper;
import org.jgroups.View;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class RegionManager {
    public static final int CAPACITY = 200000;
    static final String DEFAULT_REGION = "/_default_/";
    private static final Log log_ = LogFactory.getLog((Class)(class$org$jboss$cache$eviction$RegionManager == null ? (class$org$jboss$cache$eviction$RegionManager = RegionManager.class$("org.jboss.cache.eviction.RegionManager")) : class$org$jboss$cache$eviction$RegionManager));
    private final Map regionMap_ = new LinkedHashMap();
    private Region[] regions_ = null;
    private boolean hasDefaultRegionOnly = false;
    private Timer evictionThread_;
    private EvictionTimerTask evictionTimerTask_ = new EvictionTimerTask();
    private int evictionThreadWakeupIntervalSeconds_;
    private TreeCache cache_;
    static /* synthetic */ Class class$org$jboss$cache$eviction$RegionManager;

    public int getEvictionThreadWakeupIntervalSeconds() {
        return this.evictionThreadWakeupIntervalSeconds_;
    }

    public Region createRegion(String fqn, Element regionConfig) throws RegionNameConflictException {
        String newFqn = this.appendFqn(fqn);
        this.checkConflict(newFqn);
        EvictionPolicy policy = this.createEvictionPolicy(regionConfig);
        EvictionConfiguration config = this.configureEvictionPolicy(policy, regionConfig);
        return this.createRegion(fqn, policy, config);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Region createRegion(String fqn, EvictionPolicy policy, EvictionConfiguration config) throws RegionNameConflictException {
        String newFqn = this.appendFqn(fqn);
        this.checkConflict(newFqn);
        if (log_.isDebugEnabled()) {
            log_.debug((Object)("createRegion(): creating region for fqn- " + fqn));
        }
        Region region = new Region(newFqn, policy, config);
        Map map = this.regionMap_;
        synchronized (map) {
            this.regionMap_.put(newFqn, region);
        }
        this.evictionTimerTask_.addRegionToProcess(region);
        return region;
    }

    public void configure(TreeCache cache) {
        if (log_.isTraceEnabled()) {
            log_.trace((Object)"Configuring the eviction region manager");
        }
        this.cache_ = cache;
        EvictionTreeCacheListener listener = this.cache_ instanceof TreeCacheAop ? new AOPEvictionTreeCacheListener() : new EvictionTreeCacheListener();
        this.cache_.setEvictionListener(listener);
        Element elem = this.cache_.getEvictionPolicyConfig();
        String temp = XmlHelper.getAttr(elem, "wakeUpIntervalSeconds", "attribute", "name");
        this.evictionThreadWakeupIntervalSeconds_ = temp == null ? 5 : Integer.parseInt(temp);
        if (this.evictionThreadWakeupIntervalSeconds_ <= 0) {
            this.evictionThreadWakeupIntervalSeconds_ = 5;
        }
        NodeList list = elem.getElementsByTagName("region");
        for (int i = 0; i < list.getLength(); ++i) {
            Node node = list.item(i);
            if (node.getNodeType() != 1) continue;
            Element element = (Element)node;
            String name = element.getAttribute("name");
            try {
                this.createRegion(name, element);
                continue;
            }
            catch (RegionNameConflictException e) {
                throw new RuntimeException("Illegal region name specified for eviction policy  exception: " + (Object)((Object)e));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRegion(String fqn) {
        Region region;
        Map map = this.regionMap_;
        synchronized (map) {
            region = (Region)this.regionMap_.remove(fqn);
        }
        this.evictionTimerTask_.removeRegionToProcess(region);
    }

    public boolean hasRegion(String myFqn) {
        String newFqn = this.appendFqn(myFqn);
        return this.regionMap_.containsKey(newFqn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Region getRegion(String myFqn) {
        Region region;
        if (this.hasDefaultRegionOnly) {
            return (Region)this.regionMap_.get(DEFAULT_REGION);
        }
        String myRFqn = this.appendFqn(myFqn);
        Map map = this.regionMap_;
        synchronized (map) {
            Region[] regions = this.getRegions();
            for (int i = 0; i < regions.length; ++i) {
                String fqn = regions[i].getFqn();
                if (!myRFqn.startsWith(fqn)) continue;
                return regions[i];
            }
        }
        if (log_.isTraceEnabled()) {
            log_.trace((Object)("getRegion(): not user-specified region found for this fqn- " + myFqn + " will use the global default region"));
        }
        if ((region = (Region)this.regionMap_.get(DEFAULT_REGION)) == null) {
            throw new RuntimeException("RegionManager.getRegion(): Default region (_default_) is not configured! You will need to define it in your EvictionPolicyConfig.");
        }
        return region;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Region[] getRegions() {
        Map map = this.regionMap_;
        synchronized (map) {
            if (this.regions_ != null && this.regions_.length == this.regionMap_.size()) {
                return this.regions_;
            }
            Region[] regions = this.regionMap_.values().toArray(new Region[0]);
            if (log_.isDebugEnabled()) {
                log_.debug((Object)("getRegions(): size of region " + regions.length));
            }
            this.regions_ = regions;
        }
        this.hasDefaultRegionOnly = this.regions_.length == 1 && this.regionMap_.containsKey(DEFAULT_REGION);
        return this.regions_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkConflict(String myFqn) throws RegionNameConflictException {
        Map map = this.regionMap_;
        synchronized (map) {
            Region[] regions = this.getRegions();
            for (int i = 0; i < regions.length; ++i) {
                String fqn = regions[i].getFqn();
                if (!myFqn.equals(fqn) && !myFqn.startsWith(fqn)) continue;
                throw new RegionNameConflictException("RegionManager.checkConflict(): new region fqn " + myFqn + " is in conflict with current region fqn- " + fqn);
            }
        }
    }

    final void setTreeCache(TreeCache cache) {
        this.cache_ = cache;
    }

    private String appendFqn(String fqn) {
        if (!fqn.endsWith("/")) {
            return fqn + "/";
        }
        return fqn;
    }

    private EvictionConfiguration configureEvictionPolicy(EvictionPolicy policy, Element regionConfig) {
        try {
            EvictionConfiguration configuration = (EvictionConfiguration)policy.getEvictionConfigurationClass().newInstance();
            configuration.parseXMLConfig(regionConfig);
            return configuration;
        }
        catch (ConfigureException e) {
            throw new RuntimeException("Error configuring Eviction Policy", e);
        }
        catch (Exception e) {
            throw new RuntimeException("Eviction configuration class is not properly loaded in classloader", e);
        }
    }

    private EvictionPolicy createEvictionPolicy(Element regionConfig) {
        String evictionClass = regionConfig.getAttribute("policyClass");
        if (!(evictionClass != null && evictionClass.length() != 0 || (evictionClass = this.cache_.getEvictionPolicyClass()) != null && evictionClass.length() != 0)) {
            throw new RuntimeException("There is no Eviction Policy Class specified on the region or for the entire cache!");
        }
        try {
            if (log_.isTraceEnabled()) {
                log_.trace((Object)("Creating policy " + evictionClass));
            }
            EvictionPolicy policy = (EvictionPolicy)this.loadClass(evictionClass).newInstance();
            policy.configure(this.cache_);
            return policy;
        }
        catch (Exception e) {
            throw new RuntimeException("Eviction class is not properly loaded in classloader", e);
        }
    }

    private Class loadClass(String classname) throws ClassNotFoundException {
        ClassLoader cl = this.getClass().getClassLoader();
        if (cl == null) {
            cl = ClassLoader.getSystemClassLoader();
        }
        return cl.loadClass(classname);
    }

    public static boolean isUsingNewStyleConfiguration(Element evictionRegionConfigElem) {
        if (evictionRegionConfigElem == null) {
            return false;
        }
        NodeList list = evictionRegionConfigElem.getElementsByTagName("region");
        for (int i = 0; i < list.getLength(); ++i) {
            Element element;
            String evictionClass;
            Node node = list.item(i);
            if (node.getNodeType() != 1 || (evictionClass = (element = (Element)node).getAttribute("policyClass")) == null || evictionClass.trim().length() <= 0) continue;
            return true;
        }
        return false;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class AOPEvictionTreeCacheListener
    extends EvictionTreeCacheListener
    implements TreeCacheListener {
        AOPEvictionTreeCacheListener() {
        }

        public void nodeCreated(Fqn fqn) {
            if (this.isInternalNode(fqn)) {
                return;
            }
            super.nodeCreated(fqn);
        }

        public void nodeVisited(Fqn fqn) {
            Region region = RegionManager.this.getRegion(fqn.toString());
            if (!region.getEvictionPolicy().canIgnoreEvent(fqn)) {
                if (log_.isTraceEnabled()) {
                    log_.trace((Object)("nodeVisited(): fqn- " + fqn));
                }
                region.setVisitedNode(fqn);
                if (this.isAopNode(fqn)) {
                    this.visitChildrenRecursively(region, fqn);
                }
            }
        }

        public void nodeRemoved(Fqn fqn) {
            if (this.isInternalNode(fqn)) {
                return;
            }
            super.nodeRemoved(fqn);
        }

        private boolean isAopNode(Fqn fqn) {
            try {
                return RegionManager.this.cache_.peek(fqn, AOPInstance.KEY) != null;
            }
            catch (Exception e) {
                log_.warn((Object)("isAopNode(): cache get operation generated exception " + e));
                return false;
            }
        }

        private void visitChildrenRecursively(Region region, Fqn fqn) {
            int size;
            Set set = null;
            try {
                set = RegionManager.this.cache_.getChildrenNames(fqn);
            }
            catch (CacheException e) {
                e.printStackTrace();
            }
            int n = size = set == null ? 0 : set.size();
            if (log_.isTraceEnabled()) {
                log_.trace((Object)("nodeVisited(): is an aop node. fqn- " + fqn + " size of children is " + size));
            }
            if (set == null) {
                return;
            }
            Iterator it = set.iterator();
            while (it.hasNext()) {
                Object childName = it.next();
                Fqn fqnKid = new Fqn(fqn, childName);
                this.visitChildrenRecursively(region, fqnKid);
                region.setVisitedNode(fqnKid);
            }
        }

        private boolean isInternalNode(Fqn fqn) {
            return false;
        }
    }

    class EvictionTreeCacheListener
    implements TreeCacheListener {
        EvictionTreeCacheListener() {
        }

        public void nodeCreated(Fqn fqn) {
            if (fqn.isRoot()) {
                return;
            }
            Region region = RegionManager.this.getRegion(fqn.toString());
            if (!region.getEvictionPolicy().canIgnoreEvent(fqn)) {
                if (log_.isTraceEnabled()) {
                    log_.trace((Object)("nodeAdded(): fqn- " + fqn));
                }
                region.setAddedNode(fqn);
            }
        }

        public void nodeRemoved(Fqn fqn) {
            Region region = RegionManager.this.getRegion(fqn.toString());
            if (!region.getEvictionPolicy().canIgnoreEvent(fqn)) {
                if (log_.isTraceEnabled()) {
                    log_.trace((Object)("nodeRemoved(): fqn- " + fqn));
                }
                region.setRemovedNode(fqn);
            }
        }

        public void nodeLoaded(Fqn fqn) {
        }

        public void nodeEvicted(Fqn fqn) {
        }

        public void nodeModified(Fqn fqn) {
            if (log_.isTraceEnabled()) {
                log_.trace((Object)("nodeModified(): redirecting to node visited. fqn- " + fqn));
            }
            this.nodeVisited(fqn);
        }

        public void nodeVisited(Fqn fqn) {
            Region region = RegionManager.this.getRegion(fqn.toString());
            if (!region.getEvictionPolicy().canIgnoreEvent(fqn)) {
                if (log_.isTraceEnabled()) {
                    log_.trace((Object)("nodeVisited(): fqn- " + fqn));
                }
                region.setVisitedNode(fqn);
            }
        }

        public void cacheStarted(TreeCache cache) {
            log_.info((Object)"Starting eviction timer");
            RegionManager.this.evictionThread_ = new Timer();
            RegionManager.this.evictionThread_.schedule((TimerTask)RegionManager.this.evictionTimerTask_, RegionManager.this.getEvictionThreadWakeupIntervalSeconds() * 1000, (long)(RegionManager.this.getEvictionThreadWakeupIntervalSeconds() * 1000));
        }

        public void cacheStopped(TreeCache cache) {
            log_.info((Object)"Stopping eviction timer ... ");
            RegionManager.this.evictionThread_.cancel();
        }

        public void viewChange(View new_view) {
        }
    }
}

