/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.loader;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.cache.Fqn;
import org.jboss.cache.TreeCache;
import org.jboss.cache.loader.CacheLoader;
import org.jgroups.blocks.MethodCall;

public class ClusteredCacheLoader
implements CacheLoader {
    private long timeout;
    private TreeCache cache;
    private static Log log = LogFactory.getLog((Class)(class$org$jboss$cache$loader$ClusteredCacheLoader == null ? (class$org$jboss$cache$loader$ClusteredCacheLoader = ClusteredCacheLoader.class$("org.jboss.cache.loader.ClusteredCacheLoader")) : class$org$jboss$cache$loader$ClusteredCacheLoader));
    static /* synthetic */ Class class$org$jboss$cache$loader$ClusteredCacheLoader;

    public void setConfig(Properties url) {
        String timeoutStr = url.getProperty("timeout");
        this.timeout = Long.valueOf(timeoutStr);
    }

    public void setCache(TreeCache c) {
        this.cache = c;
    }

    public Set getChildrenNames(Fqn fqn) throws Exception {
        MethodCall call = new MethodCall(TreeCache.getChildrenNamesMethodLocal, new Object[]{fqn});
        List resps = this.callRemote(call);
        return resps.size() == 0 ? null : (Set)resps.get(0);
    }

    private List callRemote(MethodCall call) throws Exception {
        if (log.isTraceEnabled()) {
            log.trace((Object)("cache=" + this.cache.getLocalAddress() + "; callRemote called with " + call));
        }
        Vector mbrs = this.cache.getMembers();
        List resps = this.cache.callRemoteMethods(mbrs, call, 1, true, this.timeout);
        Iterator i = resps.iterator();
        while (i.hasNext()) {
            Object o = i.next();
            if (!(o instanceof Exception)) continue;
            if (log.isDebugEnabled()) {
                log.debug((Object)"Found remote exception among responses - removing from responses list", (Throwable)((Exception)o));
            }
            i.remove();
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("got responses " + resps));
        }
        return resps;
    }

    public Map get(Fqn name) throws Exception {
        MethodCall call = new MethodCall(TreeCache.getDataMapMethodLocal, new Object[]{name});
        List resps = this.callRemote(call);
        return resps.size() == 0 ? null : (Map)resps.get(0);
    }

    public boolean exists(Fqn name) throws Exception {
        MethodCall call = new MethodCall(TreeCache.existsMethod, new Object[]{name});
        List resps = this.callRemote(call);
        return resps.size() != 0 && (Boolean)resps.get(0) != false;
    }

    public Object put(Fqn name, Object key, Object value) throws Exception {
        Map map = this.get(name);
        return map == null ? null : map.get(key);
    }

    public void put(Fqn name, Map attributes) throws Exception {
    }

    public void put(List modifications) throws Exception {
    }

    public Object remove(Fqn name, Object key) throws Exception {
        Map map = this.get(name);
        return map == null ? null : map.get(key);
    }

    public void remove(Fqn name) throws Exception {
    }

    public void removeData(Fqn name) throws Exception {
    }

    public void prepare(Object tx, List modifications, boolean one_phase) throws Exception {
    }

    public void commit(Object tx) throws Exception {
    }

    public void rollback(Object tx) {
    }

    public byte[] loadEntireState() throws Exception {
        return new byte[0];
    }

    public void storeEntireState(byte[] state) throws Exception {
    }

    public void create() throws Exception {
    }

    public void start() throws Exception {
    }

    public void stop() {
    }

    public void destroy() {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

