/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.optimistic;

import EDU.oswego.cs.dl.util.concurrent.ConcurrentHashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.TreeSet;
import org.jboss.cache.Fqn;
import org.jboss.cache.TreeCache;
import org.jboss.cache.optimistic.FqnComparator;
import org.jboss.cache.optimistic.TransactionWorkspace;
import org.jboss.cache.optimistic.WorkspaceNode;

public class TransactionWorkspaceImpl
implements TransactionWorkspace {
    private Map nodes;
    private TreeCache cache;
    private boolean versioningImplicit = true;
    private static FqnComparator fqnComparator = new FqnComparator();

    public TransactionWorkspaceImpl() {
        this.initNodeMap();
    }

    private void initNodeMap() {
        this.nodes = new ConcurrentHashMap(new TreeMap(fqnComparator));
    }

    public void setCache(TreeCache cache) {
        this.cache = cache;
    }

    public TreeCache getCache() {
        return this.cache;
    }

    public Map getNodes() {
        return this.nodes;
    }

    public void setNodes(Map nodes) {
        this.nodes = nodes;
    }

    public WorkspaceNode getNode(Fqn fqn) {
        return (WorkspaceNode)this.nodes.get(fqn);
    }

    public void addNode(WorkspaceNode node) {
        this.nodes.put(node.getFqn(), node);
    }

    public Object removeNode(Fqn fqn) {
        return this.nodes.remove(fqn);
    }

    public SortedMap getNodesAfter(Fqn fqn) {
        return this.buildSortedMap(fqn);
    }

    private SortedMap buildSortedMap(Fqn fqn) {
        TreeSet ss = new TreeSet(fqnComparator);
        ss.addAll(this.nodes.keySet());
        Iterator it = ss.iterator();
        TreeMap sm = new TreeMap(fqnComparator);
        boolean addToMap = false;
        while (it.hasNext()) {
            Object key = it.next();
            if (!(addToMap = addToMap || key.equals(fqn))) continue;
            sm.put(key, this.nodes.get(key));
        }
        return sm;
    }

    public boolean isVersioningImplicit() {
        return this.versioningImplicit;
    }

    public void setVersioningImplicit(boolean versioningImplicit) {
        this.versioningImplicit = versioningImplicit;
    }

    public String toString() {
        StringBuffer b = new StringBuffer(super.toString());
        if (this.nodes != null) {
            b.append("[Num elements: ").append(this.nodes.size()).append("]");
        } else {
            b.append("[Num elements: null]");
        }
        return b.toString();
    }
}

